/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.IRentSettlementService;
import com.ejianc.business.rmat.vo.RentContractPayVO;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.rmat.vo.RentSettlementRecordVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rentContract"})
public class RentContractController {
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentSettlementService rentSettlementService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IPayContractApi payContractApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentContractVO> saveOrUpdate(@RequestBody RentContractVO rentContractVo) {
        return this.rentContractService.saveOrUpdate(rentContractVo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentContractVO> queryDetail(@RequestParam Long id) {
        RentContractVO rentContractVo = this.rentContractService.queryDetail(id);
        return CommonResponse.success((Object)rentContractVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentContractVO> vos) {
        this.rentContractService.deleteRentContract(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.rentContractService.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.rentContractService.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), RentContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("rentCount", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @GetMapping(value={"/rentContractRef"})
    public CommonResponse<IPage<RentContractVO>> projectListRefe(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        Long orgId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Long projectId;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("supplierId")) {
                projectId = Long.valueOf(conditionMap.get("supplierId").toString());
                queryParam.getParams().put("supplierId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }
        orgId = orgId != null ? orgId : InvocationInfoProxy.getOrgId();
        queryParam.getOrderMap().put("create_time", "desc");
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<RentContractVO> list = this.rentContractService.queryContract((Page<RentContractVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, RentContractVO.class));
        return CommonResponse.success((String)"\u79df\u8d41\u5408\u540c\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryInvoiceDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRecordVO> queryInvoiceDetail(@RequestParam Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(id));
        CommonResponse res = this.invoiceApi.getInvoiceReceiveRecord(id);
        if (!res.isSuccess() || !res.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6536\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        InvoiceReceiveRecordVO vo = (InvoiceReceiveRecordVO)res.getData();
        if (null != vo) {
            vo.setContractTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        }
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/queryPayDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentContractPayVO> queryPayDetail(@RequestParam Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(id));
        RentContractPayVO rentContractPayVO = (RentContractPayVO)BeanMapper.map((Object)((Object)entity), RentContractPayVO.class);
        CommonResponse sumPayMnyVOList = this.payContractApi.getSumPayMnyVOList(id, InvocationInfoProxy.getOrgId());
        if (!sumPayMnyVOList.isSuccess() || !sumPayMnyVOList.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6536\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVOList.getData()).getSumPayMny() == null ? BigDecimal.ZERO : ((SumPayMnyVO)sumPayMnyVOList.getData()).getSumPayMny();
        rentContractPayVO.setContractId(((SumPayMnyVO)sumPayMnyVOList.getData()).getContractId());
        rentContractPayVO.setSumPayMny(sumPayMny);
        rentContractPayVO.setContractVOList(((SumPayMnyVO)sumPayMnyVOList.getData()).getContractVOList());
        RentSettlementRecordVO settlementRecordVO = this.rentSettlementService.querySettlementRecord(id);
        BigDecimal sumSettlementTaxMny = settlementRecordVO.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : settlementRecordVO.getSumSettlementTaxMny();
        rentContractPayVO.setSumSettlementTaxMny(sumSettlementTaxMny);
        CommonResponse res = this.invoiceApi.getInvoiceReceiveRecord(id);
        if (!res.isSuccess() || !res.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6536\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        rentContractPayVO.setSumInvoiceTaxMny(((InvoiceReceiveRecordVO)res.getData()).getInvoiceTaxMny());
        rentContractPayVO.setSumUnPayMny(sumSettlementTaxMny.subtract(sumPayMny));
        return CommonResponse.success((Object)rentContractPayVO);
    }

    @PostMapping(value={"changeState"})
    public CommonResponse<String> changeState(@RequestBody RentContractVO rentContractVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)rentContractVO.getId());
        updateWrapper.set(RentContractEntity::getContractStatus, (Object)rentContractVO.getContractStatus());
        this.rentContractService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(-1);
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        queryParam.getComplexParams().add(this.getPageQueryParam(InvocationInfoProxy.getOrgId()));
        IPage pageData = this.rentContractService.queryPage(queryParam, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), RentContractVO.class);
            list.forEach(vo -> {
                if ("1".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("\u672a\u7b7e\u8ba2");
                } else if ("2".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("\u5c65\u7ea6\u4e2d");
                } else if ("3".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("\u5df2\u5c01\u8d26");
                }
                if (vo.getChangeStatus() == 1) {
                    vo.setChangeStatusName("\u672a\u53d8\u66f4");
                } else if (vo.getChangeStatus() == 2) {
                    vo.setChangeStatusName("\u53d8\u66f4\u4e2d");
                } else if (vo.getChangeStatus() == 3) {
                    vo.setChangeStatusName("\u5df2\u53d8\u66f4");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("rentContractListExport.xlsx", beans, response);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentOrgIds = new ArrayList();
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("rent_type", new Parameter("eq", (Object)"2"));
            c3.getParams().put("org_id", new Parameter("in", parentOrgIds));
            c1.getComplexParams().add(c3);
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        }
        return c1;
    }

    @PostMapping(value={"analysisContract"})
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        Map<String, Object> result;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        if (null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((Collection)((List)param.get("projectIds")))) {
            queryParam.getParams().put("projectId", new Parameter("in", param.get("projectIds")));
        }
        String dataStr = null != (result = this.rentContractService.countContractAmount(queryParam)) && null != result.get("curAmount") ? result.get("curAmount").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);
        return CommonResponse.success((Object)total.divide(new BigDecimal(10000), 2, 4));
    }

    @GetMapping(value={"/rmatEffectiveContract"})
    public CommonResponse<IPage<RentContractVO>> rmatEffectiveContract(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        Long orgId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Long projectId;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("supplierId")) {
                projectId = Long.valueOf(conditionMap.get("supplierId").toString());
                queryParam.getParams().put("supplierId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }
        orgId = orgId != null ? orgId : InvocationInfoProxy.getOrgId();
        queryParam.getOrderMap().put("create_time", "desc");
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.rentContractService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), RentContractVO.class));
        return CommonResponse.success((String)"\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }
}

