/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.rmat.bean.RentContractDetailEntity;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.controller.SqlParam;
import com.ejianc.business.rmat.mapper.RentContractMapper;
import com.ejianc.business.rmat.service.CommonBillCodeService;
import com.ejianc.business.rmat.service.IRentChangeService;
import com.ejianc.business.rmat.service.IRentContractDetailService;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.vo.RentContractDetailVO;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RentContractService")
public class RentContractServiceImpl
extends BaseServiceImpl<RentContractMapper, RentContractEntity>
implements IRentContractService {
    private static final String RENT_CONTRACT_BILL_CODE = "RMAT_CONTRACT";
    @Autowired
    private IRentChangeService rentChangeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private CommonBillCodeService commonBillCodeService;

    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = (RentContractEntity)((Object)BeanMapper.map((Object)rentContractVo, RentContractEntity.class));
        Object operateType = null;
        List entities = null;
        List entitiesc = null;
        if (StringUtils.isEmpty((CharSequence)rentContractVo.getBillCode())) {
            String code = this.commonBillCodeService.getCodeByOrgId(rentContractVo.getOrgId(), RENT_CONTRACT_BILL_CODE, (BaseVO)rentContractVo);
            entity.setBillCode(code);
        }
        if (rentContractVo.getId() != null && rentContractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RentContractEntity::getSupplementFlag, (Object)0);
            lambda.eq(RentContractEntity::getBillCode, (Object)rentContractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)rentContractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)rentContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)rentContractVo.getId()));
            entitiesc = this.rentChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(RentContractEntity::getSupplementFlag, (Object)0);
            lambda.eq(RentContractEntity::getBillCode, (Object)rentContractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)rentContractVo.getBillCode()));
            entitiesc = this.rentChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if (CollectionUtils.isNotEmpty((Collection)entities) || CollectionUtils.isNotEmpty((Collection)entitiesc)) {
            return CommonResponse.error((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMoney(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBaseTaxMoney(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)super.selectById((Serializable)id));
        entity.setRentdetail(null);
        RentContractVO rentContractVo = (RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId, (Object)id);
        lambda.ne(RentContractDetailEntity::getChangeType, (Object)"3");
        details = this.rentContractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            rentContractVo.setRentdetail(BeanMapper.mapList((Iterable)details, RentContractDetailVO.class));
        }
        return rentContractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = RentContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public void deleteRentContract(List<RentContractVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).querySettleWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).queryPayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).queryPrePayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).queryTaxWarnContract(sqlParamList);
    }
}

