/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.rmat.bean.RentContractDetailEntity;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.bean.RentSettlementEntity;
import com.ejianc.business.rmat.controller.SqlParam;
import com.ejianc.business.rmat.mapper.RentContractMapper;
import com.ejianc.business.rmat.service.IRentChangeService;
import com.ejianc.business.rmat.service.IRentContractDetailService;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.IRentSettlementService;
import com.ejianc.business.rmat.vo.RentContractDetailVO;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.rmat.vo.RmatProjectReportVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RentContractService")
public class RentContractServiceImpl
extends BaseServiceImpl<RentContractMapper, RentContractEntity>
implements IRentContractService {
    private static final String RENT_CONTRACT_BILL_CODE = "RMAT_CONTRACT";
    @Autowired
    private IRentChangeService rentChangeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private IRentSettlementService settlementService;

    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = (RentContractEntity)((Object)BeanMapper.map((Object)rentContractVo, RentContractEntity.class));
        List entities = null;
        List entitiesc = null;
        if (StringUtils.isEmpty((CharSequence)rentContractVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RENT_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (StringUtils.isEmpty((CharSequence)rentContractVo.getIsSupplement())) {
                entity.setIsSupplement("0");
            }
        }
        if (rentContractVo.getId() != null && rentContractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RentContractEntity::getSupplementFlag, (Object)0);
            lambda.eq(RentContractEntity::getBillCode, (Object)rentContractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)rentContractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)rentContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)rentContractVo.getId()));
            entitiesc = this.rentChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(RentContractEntity::getSupplementFlag, (Object)0);
            lambda.eq(RentContractEntity::getBillCode, (Object)rentContractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)rentContractVo.getBillCode()));
            entitiesc = this.rentChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if (CollectionUtils.isNotEmpty((Collection)entities) || CollectionUtils.isNotEmpty((Collection)entitiesc)) {
            return CommonResponse.error((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMoney(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBaseTaxMoney(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)super.selectById((Serializable)id));
        entity.setRentdetail(null);
        RentContractVO rentContractVo = (RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId, (Object)id);
        lambda.apply("ISNULL(change_type) <> 3", new Object[0]);
        details = this.rentContractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            rentContractVo.setRentdetail(BeanMapper.mapList((Iterable)details, RentContractDetailVO.class));
        }
        return rentContractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = RentContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public void deleteRentContract(List<RentContractVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).querySettleWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).queryPayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).queryPrePayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).queryTaxWarnContract(sqlParamList);
    }

    @Override
    public List<RmatProjectReportVo> getMonthRmatMny(Long projectId, Integer lastDay) {
        return ((RentContractMapper)this.baseMapper).getMonthRmatMny(projectId, lastDay);
    }

    @Override
    public RmatProjectReportVo getRmatContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentContractEntity::getProjectId, (Object)projectId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(RentContractEntity::getSupplementFlag, (Object)0);
        wrapper.in(RentContractEntity::getBillState, billStatus);
        List contractEntityList = super.list((Wrapper)wrapper);
        for (RentContractEntity entity : contractEntityList) {
            mny = MathUtil.safeAdd((BigDecimal)mny, (BigDecimal)entity.getContractTaxMny());
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(RentSettlementEntity::getProjectId, (Object)projectId);
        wrapper2.eq(BaseEntity::getDr, (Object)0);
        wrapper2.in(RentSettlementEntity::getBillState, billStatus);
        List settlementEntityList = this.settlementService.list((Wrapper)wrapper2);
        for (RentSettlementEntity entity : settlementEntityList) {
            settleMny = MathUtil.safeAdd((BigDecimal)settleMny, (BigDecimal)entity.getSettlementTaxMny());
        }
        RmatProjectReportVo vo = new RmatProjectReportVo();
        vo.setMny(mny);
        vo.setNum(Integer.valueOf(contractEntityList.size()));
        vo.setSettleMny(settleMny);
        return vo;
    }
}

