package com.ejianc.business.rmat.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 租赁合同明细
 * </p>
 */
@TableName("ejc_rmat_contract_detail")
public class RentContractDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;


    /**
     * 计划主键
     */
    @TableField("plan_id")
    private Long planId;

    /**
     * 计划子表主键
     */
    @TableField("plan_detail_id")
    private Long planDetailId;

    /**
     * 物资分类编码
     */
    @TableField(value = "material_type_code")
    private String materialTypeCode;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;

    /**
     * 物资分类id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 物资编码
     */
    @TableField(value = "material_code")
    private String materialCode;

    /**
     * 物资id
     */
    @TableField(value = "material_id")
    private Long materialId;


    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;

    /**
     * 规格型号
     */
    @TableField("spec")
    private String spec;

    /**
     * 计费方式
     */
    @TableField("charge_type")
    private String chargeType;

    /**
     * 计量单位
     */
    @TableField("unit_name")
    private String unitName;

    /**
     * 起租时间
     */
    @TableField("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 停租时间
     */
    @TableField("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 租期
     */
    @TableField("rent_term")
    private String rentTerm;

    /**
     * 单价
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 数量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 金额
     */
    @TableField("money")
    private BigDecimal money;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更子表主键
     */
    @TableField("change_bid")
    private Long changeBid;

    /**
     * 变更类型
     */
    @TableField("change_type")
    private String changeType;

    /**
     * 来源类型 1-计划，2-材料库
     */
    @TableField("source")
    private Integer source;

    @TableField(value="src_supplement_flag")
    private Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    @TableField(value="src_supplement_id")
    private Long srcSupplementId; // 来源补充协议主表ID
    @TableField(value="src_supplement_detail_id")
    private Long srcSupplementDetailId; // 来源补充协议明细ID


    @TableField("detail_tax_rate")
    private BigDecimal detailTaxRate;//税率
    @TableField("tax_price")
    private BigDecimal taxPrice;//含税单价
    @TableField("tax_money")
    private BigDecimal taxMoney;//含税金额
    @TableField("tax")
    private BigDecimal tax;//税额
    @TableField(exist = false)
    private BigDecimal sumNum;
    
    
    

    public BigDecimal getSumNum() {
		return sumNum;
	}

	public void setSumNum(BigDecimal sumNum) {
		this.sumNum = sumNum;
	}

	public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }

    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }

    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

    public Long getContractId() {
        return contractId;
    }


    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Long getPlanDetailId() {
        return planDetailId;
    }

    public void setPlanDetailId(Long planDetailId) {
        this.planDetailId = planDetailId;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getChargeType() {
        return chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getRentTerm() {
        return rentTerm;
    }

    public void setRentTerm(String rentTerm) {
        this.rentTerm = rentTerm;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getChangeBid() {
        return changeBid;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

}
