package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.mapper.RentContractMapper;
import com.ejianc.business.rmat.mapper.RentSettlementDetailMapper;
import com.ejianc.business.rmat.mapper.RentSettlementMapper;
import com.ejianc.business.rmat.service.*;
import com.ejianc.business.rmat.vo.RentSettlementDetailVO;
import com.ejianc.business.rmat.vo.RentSettlementRecordVO;
import com.ejianc.business.rmat.vo.RentSettlementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 设备合同结算表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@Service("RentSettlementService")
public class RentSettlementServiceImpl extends BaseServiceImpl<RentSettlementMapper, RentSettlementEntity> implements IRentSettlementService {
    private static final String RENT_SETTLEMENT_BILL_CODE = "QDSZ_RMAT_RENT_SETTLEMENT";
    private static final String RMAT_RENT_SETTLE = "RMAT_RENT_SETTLE";
    private static final String RMAT_RENT_SETTLE_DETAIL = "RMAT_RENT_SETTLE_DETAIL";
    private static final String RMAT_RENT_SETTLE_FEE = "RMAT_RENT_SETTLE_FEE";
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String CHECK_PARAM_CODE = "P-m2QBuz29";

    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private IRentSettlementDetailService rentSettlementDetailService;
    @Autowired
    private IRentSettlementFeeService rentSettlementFeeService ;
    @Autowired
    private RentSettlementDetailMapper rentSettlementDetailMapper ;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private RentContractMapper rentContractMapper;
    @Autowired
    private RentSettlementMapper rentSettlementMapper;
    @Autowired
    private IRentChangeService rentChangeService;


    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Override
    public CommonResponse<RentSettlementVO> saveOrUpdate(RentSettlementVO rentSettlementVo) {
        //保存时校验合同version是否一致
        if(rentSettlementVo.getContractVersion()!=null&&rentSettlementVo.getContractVersion()!=0){
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try{
                locked = RedisTool.tryLock(jedis, String.valueOf(rentSettlementVo.getContractId()), "saveOrUpdate", 1000);
                logger.info("判断单据单据锁结果------"+locked);
                if(locked){
                    RentContractEntity contractEntity = rentContractService.selectById(rentSettlementVo.getContractId());
                    Integer version = contractEntity.getVersion()==null?0:contractEntity.getVersion();
                    Integer conVersion = rentSettlementVo.getContractVersion();
                    if(!version.equals(conVersion)){
                        return CommonResponse.error("该合同已被更新，请刷新后重做！");
                    }
                }else {
                    return CommonResponse.error("出现并发操作,请稍后重试！");
                }
            }catch (Exception e) {
                e.printStackTrace();
            } finally {
                if(locked) {
                    RedisTool.releaseLock(jedis, String.valueOf(rentSettlementVo.getContractId()), "saveOrUpdate");
                }
                jedis.close();
            }

        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentSettlementEntity entity = null;
        //合同只能存在一条未生效的
        LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange.eq(RentSettlementEntity::getTenantId, tenantId);
        lambdachange.eq(RentSettlementEntity::getContractId,rentSettlementVo.getContractId());
        lambdachange.eq(RentSettlementEntity::getOrgId,rentSettlementVo.getOrgId());
        if(null!=rentSettlementVo.getId()&&rentSettlementVo.getId()>0){
            lambdachange.ne(RentSettlementEntity::getId,rentSettlementVo.getId());
        }
        lambdachange.ne(RentSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(RentSettlementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同该组织下已存在未生效的结算单!");
        }

            LambdaQueryWrapper<RentContractEntity> lambdachange2 = Wrappers.<RentContractEntity>lambdaQuery();
            lambdachange2.eq(RentContractEntity::getTenantId, tenantId);
            lambdachange2.eq(RentContractEntity::getMainContractId,rentSettlementVo.getContractId());
            lambdachange2.ne(RentContractEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdachange2.ne(RentContractEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
            int nums= rentContractService.count(lambdachange2);
            if(nums>0){
                throw new BusinessException("该合同存在未生效的合同补充协议，不允许做结算");
            }
            if(1==rentSettlementVo.getSettlementType()){
            LambdaQueryWrapper<RentChangeEntity> lambdachange3 = Wrappers.<RentChangeEntity>lambdaQuery();
            lambdachange3.eq(RentChangeEntity::getTenantId, tenantId);
            lambdachange3.eq(RentChangeEntity::getContractId,rentSettlementVo.getContractId());
            lambdachange3.ne(RentChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdachange3.ne(RentChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
            int numc= rentChangeService.count(lambdachange3);
            if(numc>0){
                throw new BusinessException("该合同存在未生效的变更单，不允许做最终结算");
            }
        }


        LambdaQueryWrapper<RentSettlementEntity> lambdachange4 = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange4.eq(RentSettlementEntity::getTenantId, tenantId);
        lambdachange4.eq(RentSettlementEntity::getContractId,rentSettlementVo.getContractId());
        lambdachange4.eq(RentSettlementEntity::getOrgId,rentSettlementVo.getOrgId());
        if(null!=rentSettlementVo.getId()&&rentSettlementVo.getId()>0){
            lambdachange4.ne(RentSettlementEntity::getId,rentSettlementVo.getId());
        }
        lambdachange4.in(RentSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambdachange4.gt(RentSettlementEntity ::getSettlementDate,rentSettlementVo.getSettlementDate());
        int num2 = super.count(lambdachange4);
        if(num2>0){
            throw new BusinessException("结算日期必须大于等于该合同对应最新结算日期!");
        }
        BigDecimal settlementTaxMny = rentSettlementVo.getSettlementTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getSettlementTaxMny();
        BigDecimal offsetMny = rentSettlementVo.getOffsetMny()==null?BigDecimal.ZERO:rentSettlementVo.getOffsetMny();//本次冲抵金额
        BigDecimal syMny = rentSettlementVo.getSymny()==null?BigDecimal.ZERO:rentSettlementVo.getSymny();//剩余冲抵金额
        if(offsetMny.compareTo(syMny)>0){
            throw new BusinessException("本次冲抵金额不允许大于剩余可冲抵金额!");
        }
        if(offsetMny.compareTo(settlementTaxMny)>0){
            throw new BusinessException("本次冲抵金额不允许大于本期结算金额");
        }
        if(StringUtils.isEmpty(rentSettlementVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_SETTLEMENT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                rentSettlementVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //设备使用记录引用标识修改
        LambdaQueryWrapper<RentSettlementDetailEntity> queryWrapperDetail = Wrappers.<RentSettlementDetailEntity>lambdaQuery();
        queryWrapperDetail.eq(RentSettlementDetailEntity::getSettlementId, rentSettlementVo.getId());
        List<RentSettlementDetailEntity> detailList = rentSettlementDetailService.list(queryWrapperDetail);
        List<Long> useOldIdList = new ArrayList<>();
        if (detailList != null && detailList.size() > 0){
            for (RentSettlementDetailEntity rentSettlementDetailEntity : detailList) {
                if (rentSettlementDetailEntity.getSource() == 3) {
                    useOldIdList.add(rentSettlementDetailEntity.getUseId());
                }
            }
        }

        //成本改造
        //设置是否关联
        rentSettlementVo.setRelationFlag("0");
        rentSettlementVo.setProportionFlag("0");
        entity = BeanMapper.map(rentSettlementVo, RentSettlementEntity.class);
        super.saveOrUpdate(entity,false);

        List<RentSettlementDetailEntity> rentdetail = entity.getRentdetail();
        if (rentdetail != null && rentdetail.size() > 0) {
            List<Long> useIds = new ArrayList<Long>();
            for (RentSettlementDetailEntity rentSettlementDetailEntity : rentdetail) {
                if(rentSettlementDetailEntity.getSource() != null){
                    if (rentSettlementDetailEntity.getSource() == 3) {
                        useIds.add(rentSettlementDetailEntity.getUseId());
                    }
                }
            }
        }

        RentSettlementVO vo = BeanMapper.map(entity, RentSettlementVO.class);

        //回写合同结算类型
        rentContractMapper.updateSettlementType(vo.getContractId(),vo.getSettlementType());

        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny =entity.getSumPrepayMny()==null?BigDecimal.ZERO:entity.getSumPrepayMny();
        BigDecimal sumOffsetMny =entity.getSumOffsetMny()==null?BigDecimal.ZERO:entity.getSumOffsetMny();
        vo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return CommonResponse.success(vo);
    }

    @Override
    public RentSettlementVO queryDetail(Long id) {
        RentSettlementEntity entity = super.selectById(id);
        RentSettlementVO rentSettlementVo = BeanMapper.map(entity, RentSettlementVO.class);
//        BigDecimal c = rentSettlementVo.getContractTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getContractTaxMny();
//        BigDecimal cc = rentSettlementVo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getSumSettlementTaxMny();
//        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
//            rentSettlementVo.setSumSettleRate(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
//        }

        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny =entity.getSumPrepayMny()==null?BigDecimal.ZERO:entity.getSumPrepayMny();
        BigDecimal sumOffsetMny =entity.getSumOffsetMny()==null?BigDecimal.ZERO:entity.getSumOffsetMny();
        rentSettlementVo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return rentSettlementVo;
    }
    @Override
    public RentSettlementVO queryDetails(Long id) {
        RentContractEntity entity = rentContractService.selectById(id);
        RentSettlementVO rentSettlementVO = BeanMapper.map(entity, RentSettlementVO.class);
        //新增逻辑处理
        rentSettlementVO.setContractId(rentSettlementVO.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        rentSettlementVO.setId(null);
        rentSettlementVO.setBillCode(null);
        rentSettlementVO.setBillState(null);
        rentSettlementVO.setCreateUserCode(null);
        rentSettlementVO.setCreateTime(null);
        rentSettlementVO.setSettlementDate(new Date());
        rentSettlementVO.setUpdateUserCode(null);
        rentSettlementVO.setUpdateTime(null);
        rentSettlementVO.setRentdetail(null);
        rentSettlementVO.setRentfee(null);
        rentSettlementVO.setTaxMny(BigDecimal.ZERO);
        rentSettlementVO.setSettlementType(0);
        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(id,entity.getOrgId());
        if(!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        rentSettlementVO.setSumPayMny(sumPayMny==null?BigDecimal.ZERO:sumPayMny);
        rentSettlementVO.setSumPrepayMny(sumPrePayMny==null?BigDecimal.ZERO:sumPrePayMny);
        LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange.eq(RentSettlementEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(RentSettlementEntity::getContractId,id);
        lambdachange.eq(RentSettlementEntity::getOrgId,entity.getOrgId());
        lambdachange.in(RentSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<RentSettlementEntity> list = super.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e-> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny()==null? BigDecimal.ZERO:e.getSettlementTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny()==null? BigDecimal.ZERO:e.getOffsetMny());
            });
            //累计结算金额
            rentSettlementVO.setSumSettlementTaxMny(settlementMoney[0]);
            //累计冲抵金额
            rentSettlementVO.setSumOffsetMny(settlementMoney[1]);
        }
        BigDecimal sumOffsetMnys = rentSettlementVO.getSumOffsetMny()==null?BigDecimal.ZERO:rentSettlementVO.getSumOffsetMny();
        if(rentSettlementVO.getSumPrepayMny().compareTo(BigDecimal.ZERO)>=0&&sumOffsetMnys.compareTo(BigDecimal.ZERO)>=0){
            rentSettlementVO.setSymny(rentSettlementVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }

//        BigDecimal c = rentSettlementVO.getContractTaxMny()==null?BigDecimal.ZERO:rentSettlementVO.getContractTaxMny();
//        BigDecimal cc = rentSettlementVO.getSumSettlementTaxMny()==null?BigDecimal.ZERO:rentSettlementVO.getSumSettlementTaxMny();
//        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
//            rentSettlementVO.setSumSettleRate(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
//        }
        return rentSettlementVO;
    }
    @Override
    public void deleteRentSettlement(List<RentSettlementVO> vos) {
        //获取删除的主键
        List<Long> ids = new ArrayList<Long>();
        for (RentSettlementVO rentSettlementVO : vos){
            ids.add(rentSettlementVO.getId());
            RentSettlementEntity RentSettlementEntity = rentSettlementMapper.selectById(rentSettlementVO.getId());
            rentContractMapper.updateSettlementType(RentSettlementEntity.getContractId(),RentSettlementEntity.getSettlementType()==1?0:RentSettlementEntity.getSettlementType());
        }
        if (ids != null && ids.size() > 0){
            LambdaQueryWrapper<RentSettlementDetailEntity> lambda = Wrappers.<RentSettlementDetailEntity>lambdaQuery();
            lambda.in(RentSettlementDetailEntity::getSettlementId, ids);
            List<RentSettlementDetailEntity> rentSettlementDetailEntities = rentSettlementDetailService.list(lambda);
            if (rentSettlementDetailEntities != null && rentSettlementDetailEntities.size() > 0){
                List<Long> useIds = new ArrayList<Long>();
                for (RentSettlementDetailEntity rentSettlementDetailEntity : rentSettlementDetailEntities){
                    if (rentSettlementDetailEntity.getSource() == 3){
                        useIds.add(rentSettlementDetailEntity.getUseId());
                    }
                }

            }
        }
        super.removeByIds(vos.stream().map(RentSettlementVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public CommonResponse<RentSettlementVO> pushCost(RentSettlementVO rentSettlementVo) {
        RentSettlementEntity rentSettlementEntity = baseMapper.selectById(rentSettlementVo.getId());
        if (ListUtil.isNotEmpty(rentSettlementVo.getRentdetail())){
            List<RentSettlementDetailEntity> rentSettleDetail = BeanMapper.mapList(rentSettlementVo.getRentdetail(), RentSettlementDetailEntity.class);
            rentSettlementEntity.setRentdetail(rentSettleDetail);
        }
        if (ListUtil.isNotEmpty(rentSettlementVo.getRentfee())){
            List<RentSettlementFeeEntity> rentSettleFee = BeanMapper.mapList(rentSettlementVo.getRentfee(), RentSettlementFeeEntity.class);
            rentSettlementEntity.setRentfee(rentSettleFee);
        }
        super.saveOrUpdate(rentSettlementEntity,false);
        //推送数据
        if(rentSettlementEntity.getBillState()==BillStateEnum.COMMITED_STATE.getBillStateCode()||rentSettlementEntity.getBillState()==BillStateEnum.PASSED_STATE.getBillStateCode()){
            costPush(rentSettlementEntity);
        }
        return CommonResponse.success(BeanMapper.map(rentSettlementEntity, RentSettlementVO.class));
    }
    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<RentSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(RentSettlementEntity::getId, id);
        updateWrapper.set(RentSettlementEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }

    @Override
    public RentSettlementRecordVO querySettlementRecord(Long id) {
        RentSettlementRecordVO vo = new RentSettlementRecordVO();
        RentContractEntity entity = rentContractService.selectById(id);
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();//合同金额
        vo.setContractTaxMny(contractTaxMny);
        vo.setSettlementType(entity.getSettlementType());
        vo.setContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper<RentSettlementEntity> lambda = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambda.eq(RentSettlementEntity::getContractId,id);
        lambda.in(RentSettlementEntity::getOrgId,commonOrgIds);
        lambda.in(RentSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(RentSettlementEntity::getCreateTime);
        List<RentSettlementEntity> entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            entities.forEach(e-> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny()==null? BigDecimal.ZERO:e.getSettlementTaxMny());
                BigDecimal rate = ComputeUtil.safeDiv(ComputeUtil.safeAdd(e.getSettlementTaxMny(),e.getSumSettlementTaxMny()),contractTaxMny);
                rate = ComputeUtil.safeMultiply(rate,BigDecimal.valueOf(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
                e.setSumSettleRate(rate);
            });
            //累计结算金额
            vo.setSumSettlementTaxMny(settlementMoney[0]);
            BigDecimal sumSettlementTaxMny = vo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:vo.getSumSettlementTaxMny();//累计结算金额
            if(sumSettlementTaxMny.compareTo(BigDecimal.ZERO)>0&&contractTaxMny.compareTo(BigDecimal.ZERO)>0){
                vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny,8,ROUND_HALF_DOWN)));
            }else{
                vo.setSumScale(BigDecimal.ZERO);
            }
            vo.setSettlementRecord(BeanMapper.mapList(entities, RentSettlementVO.class));
        }
        return vo;
    }
    @Override
    public void costPush(RentSettlementEntity settlementEntity) {
        logger.info("开始Push");
        //1.判断结算单所有子表是否全部关联科目
        List<RentSettlementDetailEntity> rentdetail = settlementEntity.getRentdetail();
        boolean newRelationFlag = true;
        if (ListUtil.isNotEmpty(rentdetail)){
            for (RentSettlementDetailEntity rentSettlementDetailEntity : rentdetail){
                if (null == rentSettlementDetailEntity.getSubjectId() || null == rentSettlementDetailEntity.getAccountingId()){
                    newRelationFlag = false;
                    break;
                }
            }
        }
        //查询费用表是否全部关联费用科目
        List<RentSettlementFeeEntity> rentfee = settlementEntity.getRentfee();
        if (ListUtil.isNotEmpty(rentfee) && newRelationFlag){
            for (RentSettlementFeeEntity rentSettlementFeeEntity : rentfee){
                if (null == rentSettlementFeeEntity.getSubjectId() || null == rentSettlementFeeEntity.getAccountingId()){
                    newRelationFlag = false;
                    break;
                }
            }
        }
        /*if (ListUtil.isEmpty(rentdetail) && ListUtil.isEmpty(rentfee)){
            newRelationFlag = false;
        }*/

        //更新是否关联
        LambdaUpdateWrapper<RentSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(RentSettlementEntity::getId, settlementEntity.getId());
        updateWrapper.set(RentSettlementEntity::getRelationFlag, newRelationFlag ? "1":"0");//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = settlementEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")){
            if (newRelationFlag){
                saveCost(settlementEntity);
            }
            if (!newRelationFlag){
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(settlementEntity.getId());
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")){
            if (newRelationFlag){
                //税率
                saveCost(settlementEntity);
            }
        }
    }

    private void saveCost(RentSettlementEntity settlementEntity) {
        //税率
        BigDecimal taxRate = settlementEntity.getTaxRate().divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<RentSettlementDetailEntity> pushRentDetail = settlementEntity.getRentdetail();
        if (ListUtil.isNotEmpty(pushRentDetail)){
            for (RentSettlementDetailEntity rentSettlementDetailEntity : pushRentDetail){
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(rentSettlementDetailEntity.getSubjectId());
                costDetailVO.setSourceId(rentSettlementDetailEntity.getSettlementId());
                costDetailVO.setSourceDetailId(rentSettlementDetailEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementDetailEntity.getSettlementTaxMny()==null?BigDecimal.ZERO:rentSettlementDetailEntity.getSettlementTaxMny());
                costDetailVO.setHappenMny(rentSettlementDetailEntity.getSettlementMny()==null?BigDecimal.ZERO:rentSettlementDetailEntity.getSettlementMny());
                costDetailVO.setHappenDate(settlementEntity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(RMAT_RENT_SETTLE);
                costDetailVO.setSourceTabType(RMAT_RENT_SETTLE_DETAIL);
                costDetailVO.setProjectId(settlementEntity.getProjectId());
                costDetailVOList.add(costDetailVO);

            }
        }
        //费用
        List<RentSettlementFeeEntity> pushRentFee = settlementEntity.getRentfee();
        if (ListUtil.isNotEmpty(pushRentFee)){
            for (RentSettlementFeeEntity rentSettlementFeeEntity : pushRentFee){
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(rentSettlementFeeEntity.getSubjectId());
                costDetailVO.setSourceId(rentSettlementFeeEntity.getSettlementId());
                costDetailVO.setSourceDetailId(rentSettlementFeeEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementFeeEntity.getTaxMoney()==null?BigDecimal.ZERO:rentSettlementFeeEntity.getTaxMoney());
                costDetailVO.setHappenMny(rentSettlementFeeEntity.getFeemoney()==null?BigDecimal.ZERO:rentSettlementFeeEntity.getFeemoney());
                costDetailVO.setHappenDate(settlementEntity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(RMAT_RENT_SETTLE);
                costDetailVO.setSourceTabType(RMAT_RENT_SETTLE_FEE);
                costDetailVO.setProjectId(settlementEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)){
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            if (stringCommonResponse.isSuccess()){
            }else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    @Override
    public ParamsCheckVO checkParams(BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny) {
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal sumPayWithThisMny = sumPayMny.add(payMny);
            BigDecimal comMny = contractMny.multiply(roleValue.divide(BigDecimal.valueOf(100)));
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            if(sumPayWithThisMny.compareTo(comMny) > 0){
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("合同超结");
                paramsCheckDsVO.setWarnName("结算金额大于合同金额");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("本次结算金额：").append(payMny.toString()).append("元，合同金额*").append(roleValue).append("%:").append(comMny).append("元。超出金额：").append(sumPayWithThisMny.subtract(comMny)).append("元");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        }else{
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

            return paramsCheckVO;
        }

    @Override
    public Integer queryById(Long id,Long contractId) {
        return rentSettlementDetailMapper.queryById(id,contractId);
    }

    @Override
    public Integer queryByContractId(Long contractId) {
        return rentSettlementDetailMapper.queryByContractId(contractId);
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal settlementTaxMny, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if(billParamByCode.isSuccess() && null != billParamByCode.getData()){
            BillParamVO billParamVO = billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100)
                    , 2, BigDecimal.ROUND_HALF_UP));

            if (2 == purchaseType) {
                // 集采合同直接赋值为不控制
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            if (sumSettleMentTaxMny.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("合同超结");
                paramsCheckDsVO.setWarnName("结算金额大于合同金额");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("本次结算金额：").append(settlementTaxMny.toString())
                        .append("元，合同金额*").append(roleValue).append("%:")
                        .append(comMny).append("元。超出金额：")
                        .append(sumSettleMentTaxMny.subtract(comMny)).append("元");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        }else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVO;
    }

	@Override
	public List<RentSettlementDetailVO> settleExcelDownload(RentSettlementVO vo) {
		List<RentSettlementDetailVO> list= new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, vo.getContractId()));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<RentSettlementEntity> entityList = this.queryList(queryParam, false);
        for (RentSettlementEntity rentSettlementEntity : entityList) {
        	queryParam = new QueryParam();
            queryParam.getParams().put("settlementId", new Parameter(QueryParam.EQ, rentSettlementEntity.getId()));
            List<RentSettlementDetailEntity> detailEntityList=rentSettlementDetailService.queryList(queryParam,false);
            if(CollectionUtils.isNotEmpty(detailEntityList)) {
	        	List<RentSettlementDetailVO> listTemp = BeanMapper.mapList(detailEntityList, RentSettlementDetailVO.class);
	        	for (RentSettlementDetailVO detailVo : listTemp) {
	        		detailVo.setSettlementCode(rentSettlementEntity.getBillCode());
				}
	        	list.addAll(listTemp);
	        	}   
		}
		return list;
	}
	
}

