/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bidprice.material.api.ImaterialPicketageApi;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.bean.RentContractDetailEntity;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.bean.RentSettlementEntity;
import com.ejianc.business.rmat.controller.SqlParam;
import com.ejianc.business.rmat.mapper.RentContractMapper;
import com.ejianc.business.rmat.service.IRentChangeService;
import com.ejianc.business.rmat.service.IRentContractDetailService;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.IRentSettlementService;
import com.ejianc.business.rmat.vo.ParamsCheckDsVO;
import com.ejianc.business.rmat.vo.ParamsCheckVO;
import com.ejianc.business.rmat.vo.RentContractControlVO;
import com.ejianc.business.rmat.vo.RentContractDetailVO;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.rmat.vo.RmatProjectReportVo;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="RentContractService")
public class RentContractServiceImpl
extends BaseServiceImpl<RentContractMapper, RentContractEntity>
implements IRentContractService {
    private static final String RENT_CONTRACT_BILL_CODE = "RMAT_CONTRACT";
    private static final String PARAM_TOTAL_MNY = "P-t58ih142";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;
    @Autowired
    private IRentChangeService rentChangeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private IRentSettlementService settlementService;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private RentContractMapper rentContractMapper;
    @Autowired
    private ImaterialPicketageApi materialPicketageApi;

    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        LambdaQueryWrapper lambda;
        if (rentContractVo.getContractTaxMny() == null) {
            rentContractVo.setContractTaxMny(BigDecimal.ZERO);
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = (RentContractEntity)((Object)BeanMapper.map((Object)rentContractVo, RentContractEntity.class));
        List entities = null;
        List entitiesc = null;
        if (StringUtils.isEmpty((CharSequence)rentContractVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RENT_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (StringUtils.isEmpty((CharSequence)rentContractVo.getIsSupplement())) {
                entity.setIsSupplement("0");
            }
        }
        if (rentContractVo.getId() != null && rentContractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RentContractEntity::getSupplementFlag, (Object)0);
            lambda.eq(RentContractEntity::getBillCode, (Object)rentContractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)rentContractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)rentContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)rentContractVo.getId()));
            entitiesc = this.rentChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(RentContractEntity::getSupplementFlag, (Object)0);
            lambda.eq(RentContractEntity::getBillCode, (Object)rentContractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)rentContractVo.getBillCode()));
            entitiesc = this.rentChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if (CollectionUtils.isNotEmpty((Collection)entities) || CollectionUtils.isNotEmpty((Collection)entitiesc)) {
            return CommonResponse.error((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMoney(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBaseTaxMoney(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        boolean b = super.saveOrUpdate((Object)entity, false);
        if (b) {
            this.countContractNumAndMnyByEnquiry(entity.getEnquiryPriceBillId());
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)super.selectById((Serializable)id));
        entity.setRentdetail(null);
        RentContractVO rentContractVo = (RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId, (Object)id);
        lambda.apply("IFNULL(change_type,0) <> 3", new Object[0]);
        details = this.rentContractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            rentContractVo.setRentdetail(BeanMapper.mapList((Iterable)details, RentContractDetailVO.class));
        }
        return rentContractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = RentContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public void deleteRentContract(List<RentContractVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BaseEntity::getId, ids);
        queryWrapper.isNotNull(RentContractEntity::getEnquiryPriceBillId);
        List rentContractEntities = this.list((Wrapper)queryWrapper);
        boolean b = super.removeByIds(ids, false);
        if (b && CollectionUtils.isNotEmpty((Collection)rentContractEntities)) {
            List<Long> enquiryPriceBillIds = rentContractEntities.stream().map(RentContractEntity::getEnquiryPriceBillId).collect(Collectors.toList());
            this.countContractNumAndMnyByEnquiry(enquiryPriceBillIds.toArray(new Long[enquiryPriceBillIds.size()]));
        }
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).querySettleWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).queryPayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).queryPrePayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        return ((RentContractMapper)this.baseMapper).queryTaxWarnContract(sqlParamList);
    }

    @Override
    public List<RmatProjectReportVo> getMonthRmatMny(Long projectId, Integer lastDay) {
        return ((RentContractMapper)this.baseMapper).getMonthRmatMny(projectId, lastDay);
    }

    @Override
    public RmatProjectReportVo getRmatContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentContractEntity::getProjectId, (Object)projectId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(RentContractEntity::getSupplementFlag, (Object)0);
        wrapper.in(RentContractEntity::getBillState, billStatus);
        List contractEntityList = super.list((Wrapper)wrapper);
        for (RentContractEntity entity : contractEntityList) {
            mny = MathUtil.safeAdd((BigDecimal)mny, (BigDecimal)entity.getContractTaxMny());
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(RentSettlementEntity::getProjectId, (Object)projectId);
        wrapper2.eq(BaseEntity::getDr, (Object)0);
        wrapper2.in(RentSettlementEntity::getBillState, billStatus);
        List settlementEntityList = this.settlementService.list((Wrapper)wrapper2);
        for (RentSettlementEntity entity : settlementEntityList) {
            settleMny = MathUtil.safeAdd((BigDecimal)settleMny, (BigDecimal)entity.getSettlementTaxMny());
        }
        RmatProjectReportVo vo = new RmatProjectReportVo();
        vo.setMny(mny);
        vo.setNum(Integer.valueOf(contractEntityList.size()));
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public BigDecimal fetchContractTaxMny(Long projectId) {
        return this.rentContractMapper.sumLastTotalContractTaxMny(projectId, null);
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(RentContractControlVO vo) {
        List billParamVOS;
        CommonResponse sghtkzc;
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        if (vo.getContractTaxMny() == null) {
            vo.setContractTaxMny(BigDecimal.ZERO);
        }
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        BudgetProjectProParamControlVO paramControlVO = new BudgetProjectProParamControlVO();
        paramControlVO.setProjectId(vo.getProjectId());
        paramControlVO.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
        CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(paramControlVO);
        if (!res.isSuccess()) {
            throw new BusinessException("\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d\uff0c\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = (BudgetProjectProQuantityAndMnyVO)res.getData();
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d\u3011 \u63a7 \u3010\u7269\u8d44\u603b\u8ba1\u5212\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            List billParamVOS2 = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS2)) {
                for (BillParamVO billParamVO : billParamVOS2) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetTaxMnyResult = quantityAndMnyVO.getMaterialTaxMny().multiply(scale);
                    BigDecimal lastTotalContractTaxMny = this.rentContractMapper.sumLastTotalContractTaxMny(vo.getProjectId(), vo.getContractId());
                    BigDecimal currentContractTaxMny = vo.getContractTaxMny();
                    BigDecimal am = lastTotalContractTaxMny.add(currentContractTaxMny);
                    CommonResponse response1 = this.materialContractApi.fetchAmountWithTax(vo.getProjectId());
                    if (!response1.isSuccess()) {
                        throw new BusinessException("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u6309\u7167\u9879\u76ee\u7ef4\u5ea6\uff0c\u5408\u540c\u603b\u91d1\u989d\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                    }
                    BigDecimal contractTaxMny = ((BigDecimal)response1.getData()).add(am);
                    if (contractTaxMny.compareTo(budgetTaxMnyResult) <= 0) continue;
                    BigDecimal over = contractTaxMny.subtract(budgetTaxMnyResult);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u603b\u91d1\u989d\u8d85\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8be5\u9879\u76ee\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u603b\u91d1\u989d\uff1a").append(contractTaxMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    RentContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }
        if ((sghtkzc = this.paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId)).isSuccess() && null != sghtkzc.getData() && CollectionUtils.isNotEmpty((Collection)(billParamVOS = (List)sghtkzc.getData()))) {
            BigDecimal sjzcje = this.getSjzcje(vo.getContractId(), vo.getProjectId(), vo.getContractTaxMny());
            CommonResponse res996 = this.incomeContractApi.fetchSghtzje(vo.getProjectId());
            if (!res996.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d\u5931\u8d25");
            }
            BigDecimal sght = (BigDecimal)res996.getData();
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal roleValue;
                BigDecimal scale;
                BigDecimal sghtzje;
                if (0 == billParamVO.getControlType() || sjzcje.compareTo(sghtzje = NumberUtil.mul((Number)sght, (Number)(scale = NumberUtil.div((Number)(roleValue = billParamVO.getRoleValue()), (Number)new BigDecimal("100"), (int)8)))) <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u8be5\u9879\u76ee\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\uff1a").append(sjzcje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d*").append(roleValue).append("%\uff1a").append(sghtzje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sjzcje, (BigDecimal)sghtzje).setScale(2, RoundingMode.HALF_UP));
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setWarnName("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                RentContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private BigDecimal getSjzcje(Long contractId, Long projectId, BigDecimal mny) {
        CommonResponse fbCommonResponse = this.subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5206\u5305\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fb = (BigDecimal)fbCommonResponse.getData();
        CommonResponse wzCommonResponse = this.materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal wz = (BigDecimal)wzCommonResponse.getData();
        BigDecimal zzc = ((RentContractMapper)this.baseMapper).fetchSjzcje(projectId, contractId);
        CommonResponse sbcgCommonResponse = this.equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u91c7\u8d2d\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbcg = (BigDecimal)sbcgCommonResponse.getData();
        CommonResponse sbzlCommonResponse = this.equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u79df\u8d41\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbzl = (BigDecimal)sbzlCommonResponse.getData();
        CommonResponse qtCommonResponse = this.otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5176\u4ed6\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal qt = (BigDecimal)qtCommonResponse.getData();
        CommonResponse fybxCommonResponse = this.financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8d39\u7528\u62a5\u9500\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fybx = (BigDecimal)fybxCommonResponse.getData();
        CommonResponse lxCommonResponse = this.financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u96f6\u661f\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal lx = (BigDecimal)lxCommonResponse.getData();
        CommonResponse yjCommonResponse = this.financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5907\u7528\u91d1\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal yj = (BigDecimal)yjCommonResponse.getData();
        return NumberUtil.add((BigDecimal[])new BigDecimal[]{mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj});
    }

    @Override
    public List<MaterialPicketageVO> countContractNumAndMnyByEnquiry(Long ... enquiryPriceBillIds) {
        if (enquiryPriceBillIds != null) {
            for (Long enquiryPriceBillId : enquiryPriceBillIds) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.select(new String[]{"count(1) as num, IFNULL(sum(contract_tax_mny),0) as money"}).eq((Object)"enquiry_price_bill_id", (Object)enquiryPriceBillId);
                Map map = this.getMap((Wrapper)queryWrapper);
                MaterialPicketageVO materialPicketageVO = new MaterialPicketageVO();
                if (MapUtils.isNotEmpty((Map)map)) {
                    Integer num = map.get("num") != null ? Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = com.ejianc.business.utils.ComputeUtil.toBigDecimal(map.get("money"));
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(num);
                    materialPicketageVO.setContractSignMny(money);
                } else {
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(Integer.valueOf(0));
                    materialPicketageVO.setContractSignMny(BigDecimal.ZERO);
                }
                this.materialPicketageApi.updateContractSignMny(materialPicketageVO);
            }
        }
        return null;
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        return ((RentContractMapper)this.baseMapper).fetchSjzcje(projectId, null);
    }
}

