
package com.ejianc.business.rmat.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.rmat.bean.RentSettlementEntity;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.IRentSettlementService;
import com.ejianc.business.rmat.vo.*;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 周转材租赁结算表 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@RestController
@RequestMapping("rentSettlement")
public class RentSettlementController {
    @Autowired
    private IRentSettlementService rentSettlementService;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IInvoiceApi invoiceApi;


    /**
     * 成本改造
     * 新增或者修改
     *
     * @param rentSettlementVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentSettlementVO> saveOrUpdate(@RequestBody RentSettlementVO rentSettlementVo) {
        LambdaQueryWrapper<RentSettlementEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(RentSettlementEntity::getSettlementType, 1);
        queryWrapper.eq(RentSettlementEntity::getContractId, rentSettlementVo.getContractId());
        queryWrapper.ne(rentSettlementVo.getId() != null, RentSettlementEntity::getId, rentSettlementVo.getId());
        int count = rentSettlementService.count(queryWrapper);
        if (count > 0) {
            return CommonResponse.error("合同存在最终结算!");
        }
        //获取已收票金额
        CommonResponse<BigDecimal> invoiceReceiceMnyRes = invoiceApi.getInvoiceReceiceMny(rentSettlementVo.getContractId(), rentSettlementVo.getOrgId());
        if (invoiceReceiceMnyRes.isSuccess()) {
            rentSettlementVo.setSumInvoiceTaxMny(ComputeUtil.nullToZero(invoiceReceiceMnyRes.getData()));
        }
        return rentSettlementService.saveOrUpdate(rentSettlementVo);

    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentSettlementVO> queryDetail(@RequestParam Long id) {
        RentSettlementVO rentSettlementVo = rentSettlementService.queryDetail(id);
        return CommonResponse.success(rentSettlementVo);
    }

    /**
     * 根据合同主键组装变更数据
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentSettlementVO> queryDetails(@RequestParam Long id) {
        RentSettlementVO rentSettlementVO = rentSettlementService.queryDetails(id);
        return CommonResponse.success(rentSettlementVO);
    }

    /**
     * 根据合同主键ID查询结算记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentSettlementRecordVO> queryDetailRecord(@RequestParam Long id) {
        RentSettlementRecordVO rentSettlementRecordVO = rentSettlementService.querySettlementRecord(id);
        return CommonResponse.success(rentSettlementRecordVO);
    }

    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentSettlementVO> vos) {
        rentSettlementService.deleteRentSettlement(vos);
        return CommonResponse.success("删除成功");
    }
    /**
     *
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        // 结算跳转付款申请制单标识
        boolean payApplyFlagHasFree = param.getParams().containsKey("payApplyFlagHasFree");
        param.getParams().remove("payApplyFlagHasFree");

        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)){
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                            .collect(Collectors.toList()));
            param.getParams().put("orgId",new Parameter("in",authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            param.getParams().put("orgId",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<RentSettlementEntity> pageData = rentSettlementService.queryPage(param, false);
        List<RentSettlementVO> voList = BeanMapper.mapList(pageData.getRecords(), RentSettlementVO.class);
        if (payApplyFlagHasFree && CollectionUtils.isNotEmpty(voList)) {
            List<Long> settleIds = voList.stream().map(e -> e.getId()).collect(Collectors.toList());
            CommonResponse<Map<Long, BigDecimal>> applyMnyHasFreeRes = payContractApi.getApplyMnyHasFree(settleIds);
            Map<Long, BigDecimal> settleApplyData = applyMnyHasFreeRes.getData();
            for (RentSettlementVO purchaseSettlementVo : voList) {
                purchaseSettlementVo.setSettleType("6");
                BigDecimal sumApplyMnyHasFree = settleApplyData.get(purchaseSettlementVo.getId());
                purchaseSettlementVo.setSumApplyMny(sumApplyMnyHasFree);
                BigDecimal surplusApplyMny = ComputeUtil.safeSub(purchaseSettlementVo.getSettlementTaxMny(), purchaseSettlementVo.getOffsetMny(), sumApplyMnyHasFree);
                purchaseSettlementVo.setSurplusApplyMny(surplusApplyMny);
            }
        }

        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", voList);
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     *
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)){
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                            .collect(Collectors.toList()));
            param.getParams().put("orgId",new Parameter("in",authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            param.getParams().put("orgId",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<RentSettlementEntity> pageData= rentSettlementService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), RentSettlementVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("SettlementName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<RentSettlementEntity> pageData= rentSettlementService.queryPage(param,false);
        List<RentSettlementVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), RentSettlementVO.class);
            System.out.println(pageData.getRecords());
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setSumSettleRate(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getSumSettlementTaxMny(),vo.getContractTaxMny()),new BigDecimal(100)));
                vo.setContainSumSettlementTaxMny(vo.getSettlementTaxMny().add(vo.getSumSettlementTaxMny()));
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("rentSettlementListExport.xlsx", beans, response);
    }

    /**
     * @Author yqls
     * @Date 2020/7/9 租赁结算参照
     * @Description rentSettlementRef
     * @Param [pageNumber, pageSize, condition, searchText]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.material.vo.RentSettlementVO>>
     */
    @RequestMapping(value = "/rentSettlementRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentSettlementVO>> rentSettlementRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        /** 剩余可申请金额不等于0  */
//        ComplexParam c4 = ParamUtil.getOrParam("surplusApplyMny", new Parameter(QueryParam.NE, 0), new Parameter(QueryParam.EQ, null));
//        queryParam.getComplexParams().add(c4);
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        if(StringUtils.isNotBlank(condition)){
            JSONObject con = JSONObject.parseObject(condition);
            if(condition.contains("contractId")){
                queryParam.getParams().put("contractId",new Parameter(QueryParam.EQ,con.getLong("contractId")));
            }
            if(condition.contains("orgId")){
                queryParam.getParams().put("orgId",new Parameter(QueryParam.EQ,con.getLong("orgId")));
            }
            if(condition.contains("supplierId")){
                queryParam.getParams().put("supplierId",new Parameter(QueryParam.EQ,con.getLong("supplierId")));
            }
        }
        IPage<RentSettlementEntity> pageData = rentSettlementService.queryPage(queryParam,false);
        IPage<RentSettlementVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List<RentSettlementVO> voList = BeanMapper.mapList(pageData.getRecords(), RentSettlementVO.class);
        if (CollectionUtils.isNotEmpty(voList)) {
            List<Long> settleIds = voList.stream().map(e -> e.getId()).collect(Collectors.toList());
            CommonResponse<Map<Long, BigDecimal>> applyMnyHasFreeRes = payContractApi.getApplyMnyHasFree(settleIds);
            Map<Long, BigDecimal> settleApplyData = applyMnyHasFreeRes.getData();
            for (RentSettlementVO purchaseSettlementVo : voList) {
                purchaseSettlementVo.setSettleType("6");
                BigDecimal sumApplyMnyHasFree = settleApplyData.get(purchaseSettlementVo.getId());
                purchaseSettlementVo.setSumApplyMny(sumApplyMnyHasFree);
                BigDecimal surplusApplyMny = ComputeUtil.safeSub(purchaseSettlementVo.getSettlementTaxMny(), purchaseSettlementVo.getOffsetMny(), sumApplyMnyHasFree);
                purchaseSettlementVo.setSurplusApplyMny(surplusApplyMny);
            }
        }
        result.setRecords(voList);
        return CommonResponse.success("参照查询成功！", result);
    }
    /**
     * @Author mrsir_wxp
     * @Date 2020/6/23 根据合同和组织查询未完成的结算单 返回为空：传合同id新增；不为空：传单据id查询
     * @Description hasNoFinishedRent
     * @Param [contractId, orgId]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Long>
     */
    @GetMapping("/hasNoFinishedRent")
    @ResponseBody
    public CommonResponse<Long> hasNoFinishedRent(@RequestParam Long contractId){
        if(contractId == null){
            return CommonResponse.error("参数错误！");
        }
        List<RentSettlementEntity> entities = getHasRentd(contractId);
        if(ListUtil.isEmpty(entities)){
            return CommonResponse.success("查询成功！");
        }else {
            return CommonResponse.success("查询成功！",entities.get(0).getId());
        }
    }
    /**
     * @Author mrsir_wxp
     * @Date 2020/6/22 根据合同和组织查询未完成的采购结算单
     * @Description getHasRentd
     * @Param [contractId, orgId]
     * @Return java.util.List<com.ejianc.business.material.bean.RentSettlementEntity>
     */
    public List<RentSettlementEntity> getHasRentd(Long contractId){
        QueryParam param = new QueryParam();
        param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractId));
        param.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode()
        )));
        return  rentSettlementService.queryList(param,false);
    }
    /**
     * 根据主键ID,orgId查询累计结算金额，累计冲抵金额,累计付款，累计预付款金额
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/querySumSettlementTaxMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentSettlementVO> querySumSettlementTaxMny(@RequestParam Long contractId,@RequestParam Long orgId) {
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        RentSettlementVO vo = new RentSettlementVO();
        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(contractId,orgId);
        if(!sumPayMnyVO.isSuccess()) {
            return CommonResponse.success("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        vo.setSumPayMny(sumPayMny==null?BigDecimal.ZERO:sumPayMny);
        vo.setSumPrepayMny(sumPrePayMny==null?BigDecimal.ZERO:sumPrePayMny);
        LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange.eq(RentSettlementEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(RentSettlementEntity::getContractId,contractId);
        lambdachange.eq(RentSettlementEntity::getOrgId,orgId);
        lambdachange.in(RentSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<RentSettlementEntity> list = rentSettlementService.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            final BigDecimal[] alreadyRentMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e-> {
                alreadyRentMoney[0] = alreadyRentMoney[0].add(e.getSettlementTaxMny()==null? BigDecimal.ZERO:e.getSettlementTaxMny());
                alreadyRentMoney[1] = alreadyRentMoney[1].add(e.getOffsetMny()==null? BigDecimal.ZERO:e.getOffsetMny());
                alreadyRentMoney[2] = alreadyRentMoney[0].add(e.getSettlementMny()==null? BigDecimal.ZERO:e.getSettlementMny());
            });
            //累计结算金额
            vo.setSumSettlementTaxMny(alreadyRentMoney[0]);
            //累计冲抵金额
            vo.setSumOffsetMny(alreadyRentMoney[1]);
            vo.setSumSettlementMny(alreadyRentMoney[2]);
        }
        BigDecimal sumOffsetMnys = vo.getSumOffsetMny()==null?BigDecimal.ZERO:vo.getSumOffsetMny();
        if(vo.getSumPrepayMny().compareTo(BigDecimal.ZERO)>=0&&sumOffsetMnys.compareTo(BigDecimal.ZERO)>=0){
            vo.setSymny(vo.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        RentContractVO rentContractVO = rentContractService.queryDetail(contractId);
        vo.setStageList(rentContractVO.getRentstage());
        return CommonResponse.success(vo);
    }
    /**
     * @Author mrsir_wxp
     * @Date 2020/6/23 根据合同和组织查询未完成的结算单 返回为空：传合同id新增；不为空：传单据id查询
     * @Description hasNoFinishedPurchase
     * @Param [contractId, orgId]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Long>
     */
    @GetMapping("/hasNoFinishedPurchase")
    @ResponseBody
    public CommonResponse<Long> hasNoFinishedPurchase(@RequestParam Long contractId){
        if(contractId == null){
            return CommonResponse.error("参数错误！");
        }
        List<RentSettlementEntity> entities = getHasPurchased(contractId);
        if(ListUtil.isEmpty(entities)){
            return CommonResponse.success("查询成功！");
        }else {
            return CommonResponse.success("查询成功！",entities.get(0).getId());
        }
    }
    /**成本改造
     * 关联保存接口
     *
     * @param rentSettlementVo
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentSettlementVO> pushCost(@RequestBody RentSettlementVO rentSettlementVo) {
        return rentSettlementService.pushCost(rentSettlementVo);
    }
    /**
     * @Author mrsir_wxp
     * @Date 2020/6/22 根据合同和组织查询未完成的采购结算单
     * @Description getHasPurchased
     * @Param [contractId, orgId]
     * @Return java.util.List<com.ejianc.business.material.bean.RentSettlementEntity>
     */
    public List<RentSettlementEntity> getHasPurchased(Long contractId){
        QueryParam param = new QueryParam();
        param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractId));
        param.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode()
        )));
        return  rentSettlementService.queryList(param,false);
    }

    /**
     * 参数校验
     *  purchaseType 采购类型
     *  sumSettleMentTaxMny 累计含本期结算金额 (合同已生效的结算金额+当前结算单金额)
     *  contractTaxMny 合同金额
     * @return
     */
    @RequestMapping(value = "/checkParams",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody RentSettlementVO vo) {

        return CommonResponse.success("参数校验成功！", rentSettlementService.checkParams(vo.getId(), vo.getContractId(), vo.getPurchaseType(), vo.getSettlementTaxMny(), vo.getContractTaxMny(), vo.getOrgId()));
    }
    /**
     * 导出清单结算明细
     *
     * @return
     */
    @PostMapping("/settleExcelDownload")
    public void settleExcelDownload(HttpServletResponse response, @RequestBody RentSettlementVO vo) {
        Map<String, Object> beans = new HashMap<>();
        List<RentSettlementDetailVO> list = rentSettlementService.settleExcelDownload(vo);
        beans.put("records", list);
        ExcelExport.getInstance().export("rentSettlement-detail-export.xlsx", beans, response);
    }

    /**
     * 下载成本科目挂接说明
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDescription", method = RequestMethod.POST)
    @ResponseBody
    public void downloadDescription(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subject-description.xlsx", "成本科目挂接说明");
    }
    
}