package com.ejianc.business.rmat.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.controller.SqlParam;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.rmat.vo.RmatProjectReportVo;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 设备合同表 Mapper 接口
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
@Mapper
public interface RentContractMapper extends BaseCrudMapper<RentContractEntity> {
    List<Map<String, Object>> querySettleWarnContract(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> queryPayWarnContract(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> queryPrePayWarnContract(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> queryTaxWarnContract(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<RentContractVO> queryContract(Page<RentContractVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    @Update("Update ejc_rmat_contract Set settlement_type = #{settlementType} where id = #{contractId}")
    void updateSettlementType(@Param("contractId") Long contractId, @Param("settlementType") Integer settlementType);

    List<RmatProjectReportVo> getMonthRmatMny(@Param(value = "projectId") Long projectId, @Param(value = "lastDay") Integer lastDay);

    /**
     * 历史累计周转材租赁合同总金额(含变更中，有变更中取变更中的)
     *
     * @param projectId  项目id
     * @param contractId 合同id
     *
     * @return {@link BigDecimal}
     */
    BigDecimal sumLastTotalContractTaxMny(@Param(value = "projectId") Long projectId,
                                          @Param(value = "contractId") Long contractId);

    BigDecimal fetchSjzcje(@Param(value = "projectId") Long projectId,
                           @Param(value = "contractId") Long contractId);
}
