package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 设备合同审批操作后
 * </p>
 *
 * @author sunyj
 * @since 2020-06-18
 */
@Service("rentContract")
public class RentContractBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IRentContractService rentContractService;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        RentContractEntity entity = rentContractService.selectById(billId);
        Integer changeStatus = entity.getChangeStatus();
        if(changeStatus == 2 || changeStatus == 3){
            return CommonResponse.error("该单据处于变更中或已变更状态，不允许弃审！");
        }
        //合同是否被其他单据引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            // 代签合同只能合同所属组织的本上级可撤回
            CommonResponse<OrgVO> contractOrg = orgApi.getOneById(entity.getPurchaseOrgId());
            if(!contractOrg.isSuccess()) {
                logger.error("弃审失败，获取合同【{}】所属组织信息失败: 【{}】", billId, contractOrg.getMsg());
                return CommonResponse.error("弃审失败，获取合同所属组织信息失败！");
            }
            CommonResponse<OrgVO> curOrg = orgApi.getOneById(InvocationInfoProxy.getOrgId());
            if(!curOrg.isSuccess()) {
                logger.error("弃审失败，获取获取当前用户【{}】所属组织信息失败: 【{}】", InvocationInfoProxy.getOrgId(), curOrg.getMsg());
                return CommonResponse.error("弃审失败，获取当前用户登录组织信息失败！");
            }
            if(!contractOrg.getData().getInnerCode().contains(curOrg.getData().getInnerCode())) {
                return CommonResponse.error("当前合同编制组织是【"+ entity.getPurchaseOrgName() +"】, 不可弃审！");
            }
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }
}
