package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.rmat.bean.RentContractClauseEntity;
import com.ejianc.business.rmat.mapper.RentContractClauseMapper;
import com.ejianc.business.rmat.service.IRentContractClauseService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 合同条款 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
@Service("RentContractClauseService")
public class RentContractClauseServiceImpl extends BaseServiceImpl<RentContractClauseMapper, RentContractClauseEntity> implements IRentContractClauseService {
    @Autowired
    private RentContractClauseMapper rentCostMapper;
    @Override
    public void deleteByContractId(Long id) {
        QueryWrapper<RentContractClauseEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("contract_id", id);
        rentCostMapper.delete(deleteWrapper);
    }
}
