package com.ejianc.business.rmat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 合同阶段表
 * </p>
 *
 * @author 曹庆伟
 * @since 2021-06-22
 */
@TableName("ejc_rmat_record_stage")
public class RentRecordStageEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同ID
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 付款阶段id(为档案时才有值)
     */
    @TableField("doc_id")
    private Long docId;

    /**
     * 付款阶段名称
     */
    @TableField("name")
    private String name;

    /**
     * 付款阶段比例
     */
    @TableField("scale")
    private BigDecimal scale;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 记录合同主键
     */
    @TableField("record_id")
    private Long recordId;

    /**
     * 原合同子表主键ID
     */
    @TableField("contract_stage_id")
    private Long contractStageId;


    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getScale() {
        return scale;
    }

    public Long getContractStageId() {
        return contractStageId;
    }

    public void setContractStageId(Long contractStageId) {
        this.contractStageId = contractStageId;
    }

    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }
}
