package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.rmat.bean.RentRecordDetailEntity;
import com.ejianc.business.rmat.bean.RentRecordEntity;
import com.ejianc.business.rmat.mapper.RentRecordMapper;
import com.ejianc.business.rmat.service.IRentRecordDetailService;
import com.ejianc.business.rmat.service.IRentRecordService;
import com.ejianc.business.rmat.vo.RentRecordDetailVO;
import com.ejianc.business.rmat.vo.RentRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 合同表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-09
 */
@Service("RentRecordService")
public class RentRecordServiceImpl extends BaseServiceImpl<RentRecordMapper, RentRecordEntity> implements IRentRecordService {
    @Autowired
    private IRentRecordDetailService rentRecordDetailService;
    @Override
    public RentRecordVO queryDetail(Long id) {
        LambdaQueryWrapper<RentRecordEntity> lambda = Wrappers.<RentRecordEntity>lambdaQuery();
        lambda.eq(RentRecordEntity::getChangeId, id);
        RentRecordEntity entity = super.getOne(lambda);
        if(null!=entity&&null!=entity.getId()){
            RentRecordEntity aggVO = super.selectById(entity.getId());
            RentRecordVO rentRecordVo = BeanMapper.map(aggVO, RentRecordVO.class);
            List<RentRecordDetailEntity> details = null;
            LambdaQueryWrapper<RentRecordDetailEntity> lambdas = Wrappers.<RentRecordDetailEntity>lambdaQuery();
            lambdas.eq(RentRecordDetailEntity::getRecordId,rentRecordVo.getId());
            lambdas.ne(RentRecordDetailEntity::getChangeType,"3");
            details = rentRecordDetailService.list(lambdas);
            if(CollectionUtils.isNotEmpty(details)){
                rentRecordVo.setRentdetail(BeanMapper.mapList(details,RentRecordDetailVO.class));
            }
            return rentRecordVo;
        }else{
            return new RentRecordVO();
        }
    }
}
