package com.ejianc.business.salary.api;

import com.ejianc.business.salary.hystrix.AcSetHystrix;
import com.ejianc.business.salary.vo.AcSetRelateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(name= "ejc-salary-web", url="${common.env.feign-client-url}", path="ejc-salary-web", fallback = AcSetHystrix.class)
public interface IAcSetApi {


    /**
     * 根据orgId新增或修改财务账套信息
     * @param  acSetRelateVO
     * @return
     */
    @PostMapping("/acSetRelate/updateProjectCwAccountInfo")
    CommonResponse<String> updateProjectCwAccountInfo(@RequestBody AcSetRelateVO acSetRelateVO);

}
