package com.ejianc.business.salary.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.salary.vo.JspayableDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应发工资计算
 * 
 * @author generator
 * 
 */
public class JspayableVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private BigDecimal payableSumMny; // 应发工资汇总
    private BigDecimal yfmsSalarySumMny; // 应发+免税
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    @JsonFormat(pattern = "yyyy-MM",timezone = "GMT+8")
    private Date month; // 月份
    
    private List<JspayableDetailVO> jspayableDetailList = new ArrayList<>(); // 应发工资计算明细
    private Long companyId; // 汇总单所属公司id
    private String companyName; // 汇总单所属公司

    private Long companyOrgId; // 汇总单所属公司id

    public Long getCompanyOrgId() {
        return companyOrgId;
    }

    public void setCompanyOrgId(Long companyOrgId) {
        this.companyOrgId = companyOrgId;
    }

    @ReferSerialTransfer(referCode="refCompanyData")
    public Long getCompanyId() {
        return companyId;
    }
    @ReferDeserialTransfer
    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public BigDecimal getYfmsSalarySumMny() {
        return yfmsSalarySumMny;
    }

    public void setYfmsSalarySumMny(BigDecimal yfmsSalarySumMny) {
        this.yfmsSalarySumMny = yfmsSalarySumMny;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPayableSumMny() {
        return payableSumMny;
    }

    public void setPayableSumMny(BigDecimal payableSumMny) {
        this.payableSumMny = payableSumMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    
     public List<JspayableDetailVO> getJspayableDetailList() {
        return jspayableDetailList;
     }

     public void setJspayableDetailList(List<JspayableDetailVO> jspayableDetailList) {
        this.jspayableDetailList = jspayableDetailList;
     }
}
