package com.ejianc.business.salary.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.salary.vo.ResendDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工资重发单
 * 
 * @author generator
 * 
 */
public class ResendVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Long orgId; // 组织id
    private String orgName; // 组织
    private String orgCode; // 组织编码
    private String acSet; // 账套
    private String acSetCode; // 账套编码
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM",timezone = "GMT+8")
    private Date month; // 月份
    private BigDecimal actualSumMny; // 累计实发工资
    private BigDecimal alreadySumMny; // 累计已发工资
    private BigDecimal leftSumMny; // 累计剩余可发工资
    private Long companyId; // 汇总单所属公司id
    private String companyName; // 汇总单所属公司
    private Long companyOrgId; // 所属公司的组织id
    private Long acId; // 账套id
    private String oldPmbillid; // PM单据id


    public Long getAcId() {
        return acId;
    }
    @ReferDeserialTransfer
    public void setAcId(Long acId) {
        this.acId = acId;
    }

    public String getOldPmbillid() {
        return oldPmbillid;
    }

    public void setOldPmbillid(String oldPmbillid) {
        this.oldPmbillid = oldPmbillid;
    }
    private List<ResendDetailVO> resendDetailList = new ArrayList<>(); // 工资重发单-明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getAcSet() {
        return acSet;
    }

    public void setAcSet(String acSet) {
        this.acSet = acSet;
    }
    public String getAcSetCode() {
        return acSetCode;
    }
//    @ReferDeserialTransfer
    public void setAcSetCode(String acSetCode) {
        this.acSetCode = acSetCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public BigDecimal getActualSumMny() {
        return actualSumMny;
    }

    public void setActualSumMny(BigDecimal actualSumMny) {
        this.actualSumMny = actualSumMny;
    }
    public BigDecimal getAlreadySumMny() {
        return alreadySumMny;
    }

    public void setAlreadySumMny(BigDecimal alreadySumMny) {
        this.alreadySumMny = alreadySumMny;
    }
    public BigDecimal getLeftSumMny() {
        return leftSumMny;
    }

    public void setLeftSumMny(BigDecimal leftSumMny) {
        this.leftSumMny = leftSumMny;
    }

    @ReferSerialTransfer(referCode="refCompanyData")
    public Long getCompanyId() {
        return companyId;
    }
    @ReferDeserialTransfer
    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public Long getCompanyOrgId() {
        return companyOrgId;
    }

    public void setCompanyOrgId(Long companyOrgId) {
        this.companyOrgId = companyOrgId;
    }
    
     public List<ResendDetailVO> getResendDetailList() {
        return resendDetailList;
     }

     public void setResendDetailList(List<ResendDetailVO> resendDetailList) {
        this.resendDetailList = resendDetailList;
     }
}
