package com.ejianc.business.salary.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 账套组织关联表
 * 
 * @author generator
 * 
 */
public class AcSetRelateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 所属组织ID
    private String orgName; // 所属组织名称
    private String orgCode; // 组织编码
    private String acSetCode; // 账套编码
    private String acSet; // 账套名称


    //查询组织金额(查询使用）
    private Integer orgBillNum = 1; // 本单位本月已制单数量
    private Integer salaryPersonNum = 0; // 发薪人数：（取本下组织所有本月单据的子表去重人员数量）
    private Integer allSalaryPersonNum = 0; // 发薪人数：（取本下组织所有本月单据的子表去重人员数量） + 本次发薪人数
    private Integer orgPersonNum; // 本组织总人数：（取本下组织所有人数）
    private BigDecimal orgBillRegisterMny = BigDecimal.ZERO; // 本单位本月已登记金额
    private BigDecimal orgAllBillRegisterMny = BigDecimal.ZERO; // 本单位本月已登记金额 + 本次登记金额
    private BigDecimal orgBillApprovalMny = BigDecimal.ZERO; // 本单位本月已审核通过金额
    private BigDecimal lastMonthMny = BigDecimal.ZERO; // 上月合计金额
    private BigDecimal difMonthMny = BigDecimal.ZERO; // 本月已制单金额对比波动
    private Long parentOrgId; // 上级组织Id
    private String parentOrgName; // 上级组织名称
    private String parentOrgCode; // 上级组织编码

    public Integer getAllSalaryPersonNum() {
        return allSalaryPersonNum;
    }

    public void setAllSalaryPersonNum(Integer allSalaryPersonNum) {
        this.allSalaryPersonNum = allSalaryPersonNum;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getSalaryPersonNum() {
        return salaryPersonNum;
    }

    public void setSalaryPersonNum(Integer salaryPersonNum) {
        this.salaryPersonNum = salaryPersonNum;
    }

    public Integer getOrgPersonNum() {
        return orgPersonNum;
    }

    public void setOrgPersonNum(Integer orgPersonNum) {
        this.orgPersonNum = orgPersonNum;
    }

    public BigDecimal getOrgAllBillRegisterMny() {
        return orgAllBillRegisterMny;
    }

    public void setOrgAllBillRegisterMny(BigDecimal orgAllBillRegisterMny) {
        this.orgAllBillRegisterMny = orgAllBillRegisterMny;
    }

    public Integer getOrgBillNum() {
        return orgBillNum;
    }

    public void setOrgBillNum(Integer orgBillNum) {
        this.orgBillNum = orgBillNum;
    }

    public BigDecimal getOrgBillRegisterMny() {
        return orgBillRegisterMny;
    }

    public void setOrgBillRegisterMny(BigDecimal orgBillRegisterMny) {
        this.orgBillRegisterMny = orgBillRegisterMny;
    }

    public BigDecimal getOrgBillApprovalMny() {
        return orgBillApprovalMny;
    }

    public void setOrgBillApprovalMny(BigDecimal orgBillApprovalMny) {
        this.orgBillApprovalMny = orgBillApprovalMny;
    }

    public BigDecimal getLastMonthMny() {
        return lastMonthMny;
    }

    public void setLastMonthMny(BigDecimal lastMonthMny) {
        this.lastMonthMny = lastMonthMny;
    }

    public BigDecimal getDifMonthMny() {
        return difMonthMny;
    }

    public void setDifMonthMny(BigDecimal difMonthMny) {
        this.difMonthMny = difMonthMny;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getAcSetCode() {
        return acSetCode;
    }

    public void setAcSetCode(String acSetCode) {
        this.acSetCode = acSetCode;
    }
    public String getAcSet() {
        return acSet;
    }

    public void setAcSet(String acSet) {
        this.acSet = acSet;
    }
    
}
