package com.ejianc.business.salary.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.salary.vo.PayrollPersonVO;
import com.ejianc.business.salary.vo.PayrollUnitVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工资单-主实体
 * 
 * @author generator
 * 
 */
public class PayrollVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private BigDecimal payableSumMny; // 累计应发工资
    private BigDecimal actualSumMny; // 累计实发工资
    private BigDecimal alreadySumMny; // 累计已发工资
    private BigDecimal leftSumMny; // 累计剩余可发工资
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    @JsonFormat(pattern = "yyyy-MM",timezone = "GMT+8")
    private Date month; // 月份
    private Long yfgzjsBillId; // 应发工资计算单据id
    private String yfgzjsBillCode; // 应发工资计算单据编码
    private Long taxBillId; // 个税计算单据id


    private String billStateName;



    private List<PayrollPersonVO> payrollPersonList = new ArrayList<>(); // 工资单-人员明细
    private List<PayrollUnitVO> payrollUnitList = new ArrayList<>(); // 工资单-单位明细

    private Long companyId; // 汇总单所属公司id
    private String companyName; // 汇总单所属公司
    private Long companyOrgId; // 汇总单所属公司id
    private Integer isPushCw; // 是否推送财务（0：否，1：是）

    public Integer getIsPushCw() {
        return isPushCw;
    }

    public void setIsPushCw(Integer isPushCw) {
        this.isPushCw = isPushCw;
    }
    public Long getCompanyOrgId() {
        return companyOrgId;
    }

    public void setCompanyOrgId(Long companyOrgId) {
        this.companyOrgId = companyOrgId;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPayableSumMny() {
        return payableSumMny;
    }

    public void setPayableSumMny(BigDecimal payableSumMny) {
        this.payableSumMny = payableSumMny;
    }
    public BigDecimal getActualSumMny() {
        return actualSumMny;
    }

    public void setActualSumMny(BigDecimal actualSumMny) {
        this.actualSumMny = actualSumMny;
    }
    public BigDecimal getAlreadySumMny() {
        return alreadySumMny;
    }

    public void setAlreadySumMny(BigDecimal alreadySumMny) {
        this.alreadySumMny = alreadySumMny;
    }
    public BigDecimal getLeftSumMny() {
        return leftSumMny;
    }

    public void setLeftSumMny(BigDecimal leftSumMny) {
        this.leftSumMny = leftSumMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public Long getYfgzjsBillId() {
        return yfgzjsBillId;
    }

    public void setYfgzjsBillId(Long yfgzjsBillId) {
        this.yfgzjsBillId = yfgzjsBillId;
    }
    public String getYfgzjsBillCode() {
        return yfgzjsBillCode;
    }

    public void setYfgzjsBillCode(String yfgzjsBillCode) {
        this.yfgzjsBillCode = yfgzjsBillCode;
    }
    
     public List<PayrollPersonVO> getPayrollPersonList() {
        return payrollPersonList;
     }

     public void setPayrollPersonList(List<PayrollPersonVO> payrollPersonList) {
        this.payrollPersonList = payrollPersonList;
     }
     public List<PayrollUnitVO> getPayrollUnitList() {
        return payrollUnitList;
     }

     public void setPayrollUnitList(List<PayrollUnitVO> payrollUnitList) {
        this.payrollUnitList = payrollUnitList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getTaxBillId() {
        return taxBillId;
    }

    public void setTaxBillId(Long taxBillId) {
        this.taxBillId = taxBillId;
    }
}
