package com.ejianc.business.sale.salesorder.api;

import com.ejianc.business.sale.salesorder.hystrix.SalesOrderHystrix;
import com.ejianc.business.sale.salesorder.vo.CloseVO;
import com.ejianc.business.sale.salesorder.vo.ProductInfoVO;
import com.ejianc.business.sale.salesorder.vo.SalesorderApiVO;
import com.ejianc.business.sale.salesorder.vo.WeighinginfoApiVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 中建科技项目rpc服务
 * 关闭生产任务单自动生成销售单
 * @author cJ
 *
 */
@FeignClient(name= "ejc-sale-web", url="${common.env.feign-client-url}", path="ejc-sale-web", fallback = SalesOrderHystrix.class)
public interface ISalesorderApi {

	/**
	 * @Description 自动生成销售单
	 */
	@PostMapping("/api/sale/saleorderApi/saveSaleorder")
	CommonResponse saveSaleorder(@RequestBody CloseVO closeVO);

	/**
	 * @Description 无人值守接口
	 */
	@PostMapping("/api/sale/saleorderApi/saveWeighinginfo")
	CommonResponse<WeighinginfoApiVO> saveWeighinginfo(@RequestBody WeighinginfoApiVO weighinginfoApiVO);

	/**
	 * @Description 提供生产任务单工程产品信息接口
	 */
	@PostMapping("/api/sale/saleorderApi/getProductInfo")
	CommonResponse<List<ProductInfoVO>> getProductInfo(@RequestParam String projectId);


}
