package com.ejianc.business.sale.salesorder.hystrix;

import com.ejianc.business.sale.salesorder.api.ISalesorderApi;
import com.ejianc.business.sale.salesorder.vo.CloseVO;
import com.ejianc.business.sale.salesorder.vo.ProductInfoVO;
import com.ejianc.business.sale.salesorder.vo.WeighinginfoApiVO;
import org.springframework.stereotype.Component;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 生成销售单的hystrix
 *
 * @author liyongjia
 *
 */
@Component
public class SalesOrderHystrix implements ISalesorderApi {

	@Override
	public CommonResponse saveSaleorder(@RequestBody CloseVO closeVO) {
		return CommonResponse.error("网络问题， 生成销售单失败!");
	}

	@Override
	public CommonResponse<WeighinginfoApiVO> saveWeighinginfo(WeighinginfoApiVO weighinginfoApiVO) {
		return CommonResponse.error("网络问题， 自动生成发货单失败!");
	}

	@Override
	public CommonResponse<List<ProductInfoVO>> getProductInfo(String projectId) {
		return CommonResponse.error("网络问题， 查询失败!");
	}

	@Override
	public CommonResponse delectSaleorder(String taskId) {
		return CommonResponse.error("网络问题， 删除失败!");
	}
}
