package com.ejianc.business.sale.salesorder.api;

import com.ejianc.business.sale.salesorder.hystrix.SalesOrderHystrix;
import com.ejianc.business.sale.salesorder.hystrix.SelectHystrix;
import com.ejianc.business.sale.salesorder.vo.NetweightSumVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/9/18
 * @description:
 */
@FeignClient(name= "ejc-sale-web", url="${common.env.feign-client-url}", path="ejc-sale-web", fallback = SelectHystrix.class)
public interface SelectApi {
    @GetMapping("/api/sale/query/queryNetweightSum")
    CommonResponse<List<NetweightSumVO>> queryNetweightSum(String shipmentDate);
}
