package com.ejianc.business.sale.salesorder.api;

import com.ejianc.business.sale.salesorder.hystrix.MasterDataHystrix;
import com.ejianc.business.sale.salesorder.vo.MasterVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 中建科技项目rpc服务
 * 关闭生产任务单自动生成销售单
 * @author cJ
 *
 */
@FeignClient(name= "ejc-sale-web", url="${common.env.feign-client-url}", path="ejc-sale-web", fallback = MasterDataHystrix.class)
public interface IMasterDataApi {

	/**
	 * @Description 自动生成销售单
	 */
	@PostMapping("/api/sale/masterData/selectMasterList")
	CommonResponse selectMasterList(@RequestBody MasterVO masterVO);





}
