/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.bean.ProductorInfoEntity;
import com.ejianc.business.sale.bean.SalesorderdetilsEntity;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.ISalesorderdetilsService;
import com.ejianc.business.sale.vo.SalesorderdetilsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"salesorderdetils"})
public class SalesorderdetilsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISalesorderdetilsService service;
    @Autowired
    private IProductorInfoService productorInfoService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalesorderdetilsVO> saveOrUpdate(@RequestBody SalesorderdetilsVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        SalesorderdetilsEntity entity = (SalesorderdetilsEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), SalesorderdetilsEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        SalesorderdetilsVO vo = (SalesorderdetilsVO)((Object)BeanMapper.map((Object)((Object)entity), SalesorderdetilsVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalesorderdetilsVO> queryDetail(Long id) {
        SalesorderdetilsEntity entity = (SalesorderdetilsEntity)((Object)this.service.selectById(id));
        SalesorderdetilsVO vo = (SalesorderdetilsVO)((Object)BeanMapper.map((Object)((Object)entity), SalesorderdetilsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalesorderdetilsVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SalesorderdetilsVO salesorderdetilsVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalesorderdetilsVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalesorderdetilsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Salesorderdetils-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSalesorderdetilsData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalesorderdetilsVO>> refSalesorderdetilsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalesorderdetilsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalesorderdetilsVO>> list(String mid) {
        QueryParam param = new QueryParam();
        param.getParams().put("project_id", new Parameter("eq", (Object)mid));
        IPage page = this.productorInfoService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        ArrayList<SalesorderdetilsEntity> list = new ArrayList<SalesorderdetilsEntity>();
        for (ProductorInfoEntity entity : page.getRecords()) {
            SalesorderdetilsEntity salesorderdetilsVO = new SalesorderdetilsEntity();
            salesorderdetilsVO.setId(entity.getId());
            salesorderdetilsVO.setProductId(entity.getProductId());
            salesorderdetilsVO.setProductName(entity.getProductName());
            salesorderdetilsVO.setSpecName(entity.getSpecName());
            salesorderdetilsVO.setStoneName(entity.getStoneName());
            salesorderdetilsVO.setAsphaltName(entity.getAsphaltName());
            salesorderdetilsVO.setCategoryId1(entity.getCategoryId1());
            salesorderdetilsVO.setCategoryName1(entity.getCategoryName1());
            salesorderdetilsVO.setVarietiesId1(entity.getVarietiesId1());
            salesorderdetilsVO.setVarietiesName1(entity.getVarietiesName1());
            salesorderdetilsVO.setThousandRate1(entity.getThousandRate1());
            salesorderdetilsVO.setCategoryId2(entity.getCategoryId2());
            salesorderdetilsVO.setCategoryName2(entity.getCategoryName2());
            salesorderdetilsVO.setVarietiesId2(entity.getVarietiesId2());
            salesorderdetilsVO.setVarietiesName2(entity.getVarietiesName2());
            salesorderdetilsVO.setThousandRate2(entity.getThousandRate2());
            salesorderdetilsVO.setCategoryId3(entity.getCategoryId3());
            salesorderdetilsVO.setCategoryName3(entity.getCategoryName3());
            salesorderdetilsVO.setVarietiesId3(entity.getVarietiesId3());
            salesorderdetilsVO.setVarietiesName3(entity.getVarietiesName3());
            salesorderdetilsVO.setThousandRate3(entity.getThousandRate3());
            salesorderdetilsVO.setUnitPrice(entity.getUnitPrice());
            list.add(salesorderdetilsVO);
        }
        List VO = BeanMapper.mapList(list, SalesorderdetilsVO.class);
        pageData.setRecords(VO);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

