/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.controller.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.sale.controller.ConstructionsiteController;
import com.ejianc.business.sale.controller.ContractController;
import com.ejianc.business.sale.controller.InvoiceController;
import com.ejianc.business.sale.controller.ManualshipmentController;
import com.ejianc.business.sale.controller.PaymentController;
import com.ejianc.business.sale.controller.ProjectInfoController;
import com.ejianc.business.sale.controller.SalesreconciliationController;
import com.ejianc.business.sale.controller.SignController;
import com.ejianc.business.sale.salesorder.vo.MasterVO;
import com.ejianc.business.sale.vo.ConstructionsiteVO;
import com.ejianc.business.sale.vo.ContractVO;
import com.ejianc.business.sale.vo.InvoiceVO;
import com.ejianc.business.sale.vo.ManualshipmentVO;
import com.ejianc.business.sale.vo.PaymentVO;
import com.ejianc.business.sale.vo.ProjectInfoVO;
import com.ejianc.business.sale.vo.SalesreconciliationVO;
import com.ejianc.business.sale.vo.SignVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sale/masterData"})
public class MasterDataApi {
    @Autowired
    private ProjectInfoController projectInfoController;
    @Autowired
    private ContractController contractController;
    @Autowired
    private ConstructionsiteController constructionsiteController;
    @Autowired
    private SignController signController;
    @Autowired
    private SalesreconciliationController salesreconciliationController;
    @Autowired
    private PaymentController paymentController;
    @Autowired
    private InvoiceController invoiceController;
    @Autowired
    private ManualshipmentController manualshipmentController;

    @RequestMapping(value={"/selectMasterList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse selectMasterList(@RequestBody MasterVO masterVO) {
        CommonResponse co = new CommonResponse();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(masterVO.getPageIndex());
        queryParam.setPageSize(masterVO.getPageSize());
        queryParam.setOrderMap(masterVO.getOrderMap());
        switch (masterVO.getStatus()) {
            case 1: {
                queryParam.getParams().put("customer_id", new Parameter("eq", (Object)masterVO.getId()));
                CommonResponse<IPage<ProjectInfoVO>> projectInfo = this.projectInfoController.queryList(queryParam);
                if (projectInfo.getCode() == 0) {
                    co.setData(projectInfo.getData());
                    break;
                }
                throw new BusinessException(projectInfo.getMsg());
            }
            case 2: {
                queryParam.getParams().put("customer_manage_id", new Parameter("eq", (Object)masterVO.getId()));
                CommonResponse<IPage<ContractVO>> contract = this.contractController.queryList(queryParam);
                if (contract.getCode() == 0) {
                    co.setData(contract.getData());
                    break;
                }
                throw new BusinessException(contract.getMsg());
            }
            case 3: {
                queryParam.getParams().put("contacts_id", new Parameter("eq", (Object)masterVO.getId()));
                CommonResponse<IPage<ConstructionsiteVO>> constructionsite = this.constructionsiteController.queryList(queryParam);
                if (constructionsite.getCode() == 0) {
                    co.setData(constructionsite.getData());
                    break;
                }
                throw new BusinessException(constructionsite.getMsg());
            }
            case 4: {
                queryParam.getParams().put("customer_id", new Parameter("eq", (Object)masterVO.getId()));
                CommonResponse<IPage<SignVO>> sign = this.signController.queryList(queryParam);
                if (sign.getCode() == 0) {
                    co.setData(sign.getData());
                    break;
                }
                throw new BusinessException(sign.getMsg());
            }
            case 5: {
                queryParam.getParams().put("customer_id", new Parameter("eq", (Object)masterVO.getId()));
                CommonResponse<IPage<SalesreconciliationVO>> salesreconciliation = this.salesreconciliationController.queryList(queryParam);
                if (salesreconciliation.getCode() == 0) {
                    co.setData(salesreconciliation.getData());
                    break;
                }
                throw new BusinessException(salesreconciliation.getMsg());
            }
            case 6: {
                queryParam.getParams().put("transport_id", new Parameter("eq", (Object)masterVO.getId()));
                CommonResponse<IPage<PaymentVO>> payment = this.paymentController.queryList(queryParam);
                if (payment.getCode() == 0) {
                    co.setData(payment.getData());
                    break;
                }
                throw new BusinessException(payment.getMsg());
            }
            case 7: {
                queryParam.getParams().put("customer_id", new Parameter("eq", (Object)masterVO.getId()));
                CommonResponse<IPage<InvoiceVO>> invoice = this.invoiceController.queryList(queryParam);
                if (invoice.getCode() == 0) {
                    co.setData(invoice.getData());
                    break;
                }
                throw new BusinessException(invoice.getMsg());
            }
            case 8: {
                queryParam.getParams().put("customer_id", new Parameter("eq", (Object)masterVO.getId()));
                CommonResponse<IPage<ManualshipmentVO>> manualshipment = this.manualshipmentController.queryList(queryParam);
                if (manualshipment.getCode() == 0) {
                    co.setData(manualshipment.getData());
                    break;
                }
                throw new BusinessException(manualshipment.getMsg());
            }
            case 9: {
                queryParam.getParams().put("shippers_id", new Parameter("eq", (Object)masterVO.getId()));
                CommonResponse<IPage<ManualshipmentVO>> manualshipments = this.manualshipmentController.queryList(queryParam);
                if (manualshipments.getCode() == 0) {
                    co.setData(manualshipments.getData());
                    break;
                }
                throw new BusinessException(manualshipments.getMsg());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)co);
    }
}

