package com.ejianc.business.sale.controller.api;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sale.bean.ProductorInfoEntity;
import com.ejianc.business.sale.bean.ProjectInfoEntity;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.salesorder.vo.CloseVO;
import com.ejianc.business.sale.salesorder.vo.ProductInfoVO;
import com.ejianc.business.sale.salesorder.vo.WeighinginfoApiVO;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.IProjectInfoService;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.IWeighinginfoService;
import com.ejianc.business.sale.vo.SalesorderVO;
import com.ejianc.business.sale.vo.SalesorderdetilsVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Transient;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/api/sale/saleorderApi/")
public class WeighinginfoApi {

    private static final String CODE = "sale-salesorder";//销售单单据编码

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IWeighinginfoService weighinginfoService;
    @Autowired
    private IProductorInfoService productorInfoService;
    @Autowired
    private IProjectInfoService projectInfoService;
    @Autowired
    private ISalesorderService salesorderService;

    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveWeighinginfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse saveWeighinginfo(@RequestBody WeighinginfoApiVO WeighinginfoApiVO) {
        weighinginfoService.saveManualshipment(WeighinginfoApiVO);
        //CommonResponse<ProductionTaskApiVo> productionTaskApiVo =  productionTaskApi.getproductiontask(WeighinginfoApiVO.getProductiontaskId().toString(),WeighinginfoApiVO.getNumberPlate());
        return CommonResponse.success("修改项目成功！");
    }

    /**
     * @Description 根据项目id查询该项目下的产品
     */
    @RequestMapping(value = "/getProductInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ProductInfoVO>> getProductInfo(@RequestParam String projectId) {
        QueryWrapper<ProductorInfoEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.eq("dr",0);
        List<ProductorInfoEntity> list = productorInfoService.list(queryWrapper);
        List<ProductInfoVO> productInfoList = new ArrayList<>();
        for(ProductorInfoEntity productorInfoEntity : list){
            ProductInfoVO productInfoVO = new ProductInfoVO();
            productInfoVO.setProductId(productorInfoEntity.getId());
            productInfoVO.setProductName(productorInfoEntity.getProductName());
            productInfoVO.setAsphaltSpec(productorInfoEntity.getAsphaltName());
            productInfoVO.setProjectTotle(productorInfoEntity.getQuantity());
            String addCount = null;
            if(productorInfoEntity.getCategoryName1() != null){
                addCount = productorInfoEntity.getCategoryName1();
            }
            if(productorInfoEntity.getCategoryName2() != null){
                addCount = addCount + ";" + productorInfoEntity.getCategoryName2();
            }
            if(productorInfoEntity.getCategoryName3() != null){
                addCount = addCount + ";" + productorInfoEntity.getCategoryName3();
            }
            if(productorInfoEntity.getTransportMethod() == 1){
                productInfoVO.setTransportMethod("代运");
            }
            if(productorInfoEntity.getTransportMethod() == 0){
                productInfoVO.setTransportMethod("自运");
            }
            productInfoVO.setAddCount(addCount);
            productInfoList.add(productInfoVO);
        }
        return CommonResponse.success("查询成功！",productInfoList);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveSaleorder", method = RequestMethod.POST)
    @ResponseBody
    @Transactional
    public CommonResponse saveSaleorder(@RequestBody CloseVO closeVO) {
        //查询工程信息
        QueryWrapper<ProjectInfoEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("id",closeVO.getProjectId());
        ProjectInfoEntity projectInfoEntity =  projectInfoService.getOne(queryWrapper);
        if(projectInfoEntity != null){
            SalesorderVO salesorderVO = new SalesorderVO();
            salesorderVO.setSalesorderType(0);
            salesorderVO.setProjectId(closeVO.getProjectId());
            salesorderVO.setProjectName(closeVO.getProjectName());
            salesorderVO.setCustomerId(closeVO.getCustomerManageId().toString());
            salesorderVO.setCustomerName(closeVO.getCustomerManageName());
            salesorderVO.setWorksiteId(closeVO.getWorksiteId());
            salesorderVO.setWorksiteName(closeVO.getWorksiteName());
            salesorderVO.setSaleDate(new Date());
            Calendar cal = Calendar.getInstance();
            int month = cal.get(Calendar.MONTH) + 1;
            int year = cal.get(Calendar.YEAR);
            String mon = "";
            if(month > 10){
                mon = "0"+ month;
            }else{
                mon = String.valueOf(month);
            }
            salesorderVO.setReceivablesTime(year + "-" + mon);
            salesorderVO.setProfitcenterId(projectInfoEntity.getProfitcenterId());
            salesorderVO.setProfitcenterName(projectInfoEntity.getProfitcenterName());
            salesorderVO.setOrgId(projectInfoEntity.getOrgId());
            salesorderVO.setOrgName(projectInfoEntity.getOrgName());
            //查询工程下产品信息
            QueryWrapper<ProductorInfoEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("id",closeVO.getProductId());
            queryWrapper1.eq("project_id",closeVO.getProjectId());
            ProductorInfoEntity productorInfoEntity = productorInfoService.getOne(queryWrapper1);
            if(productorInfoEntity != null){
                List<SalesorderdetilsVO> list = new ArrayList<>();
                //将产品信息存入销售单子表
                SalesorderdetilsVO salesorderdetilsVO = new SalesorderdetilsVO();
                salesorderdetilsVO.setProductId(productorInfoEntity.getProductId());
                salesorderdetilsVO.setProductName(productorInfoEntity.getProductName());
                salesorderdetilsVO.setSpecName(productorInfoEntity.getSpecName());
                salesorderdetilsVO.setStoneName(productorInfoEntity.getStoneName());
                salesorderdetilsVO.setAsphaltName(productorInfoEntity.getAsphaltName());
                salesorderdetilsVO.setCategoryId1(productorInfoEntity.getCategoryId1());
                salesorderdetilsVO.setCategoryName1(productorInfoEntity.getCategoryName1());
                salesorderdetilsVO.setThousandRate1(productorInfoEntity.getThousandRate1());
                salesorderdetilsVO.setCategoryId2(productorInfoEntity.getCategoryId2());
                salesorderdetilsVO.setCategoryName2(productorInfoEntity.getCategoryName2());
                salesorderdetilsVO.setThousandRate2(productorInfoEntity.getThousandRate2());
                salesorderdetilsVO.setCategoryId3(productorInfoEntity.getCategoryId3());
                salesorderdetilsVO.setCategoryName3(productorInfoEntity.getCategoryName3());
                salesorderdetilsVO.setThousandRate3(productorInfoEntity.getThousandRate3());
                salesorderdetilsVO.setUnitPrice(productorInfoEntity.getUnitPrice());
                salesorderdetilsVO.setSalesVolume(closeVO.getThisQuantity());
                salesorderdetilsVO.setSalesAmount(productorInfoEntity.getUnitPrice().multiply(closeVO.getThisQuantity()));
                salesorderdetilsVO.setProductionQuantity(closeVO.getThisQuantity());
                salesorderdetilsVO.setProductionAmount(productorInfoEntity.getUnitPrice().multiply(closeVO.getThisQuantity()));
                salesorderdetilsVO.setRowState("add");
                list.add(salesorderdetilsVO);
                salesorderVO.setSalesorderdetilsList(list);
                salesorderVO.setSalesTotalMoney(productorInfoEntity.getUnitPrice().multiply(closeVO.getThisQuantity()));
                BillCodeParam codeParam = BillCodeParam.build(CODE, InvocationInfoProxy.getTenantid(),salesorderVO);
                CommonResponse<String> code = billCodeApi.generateBillCode(codeParam);
                SalesorderEntity salesorderEntity = BeanMapper.map(salesorderVO, SalesorderEntity.class);
                if(code.isSuccess()) {
                    salesorderEntity.setBillCode(code.getData());
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                salesorderService.saveOrUpdate(salesorderEntity,false);
            }else{
                throw new BusinessException("未查到" + closeVO.getProductName() + "工程产品,不允许生成销售单!");
            }
        }else{
            throw new BusinessException("未查到" + closeVO.getProjectName() + "该工程,不允许生成销售单!");
        }
        return CommonResponse.success("生成销售单成功！");
    }

}
