package com.ejianc.business.sale.service.impl;

import com.ejianc.business.sale.bean.*;
import com.ejianc.business.sale.service.IPaymentService;
import com.ejianc.business.sale.service.IPaymentdetialService;
import com.ejianc.business.sale.service.ISignfreightService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("payment") 
public class PaymentBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPaymentService paymentService;
	@Autowired
	private ISignfreightService signfreightService;
	@Autowired
	private IPaymentdetialService paymentdetialService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		logger.info("---------进来啦--------");
		PaymentEntity paymentEntity = paymentService.selectById(billId);
		if(paymentEntity.getPaymentdetialList() != null){
			logger.info("---------不为空--------");
			for(PaymentdetialEntity paymentdetialEntity : paymentEntity.getPaymentdetialList()){
				SignfreightEntity signfreightEntity = signfreightService.getById(paymentdetialEntity.getManualshipmentId());
				signfreightEntity.setPaymentMoney(paymentdetialEntity.getDistributionMoney());
				signfreightEntity.setNotPaymentMoney(signfreightEntity.getNotPaymentMoney().subtract(paymentdetialEntity.getDistributionMoney()));
				if(signfreightEntity.getNotPaymentMoney().doubleValue() != 0.00){
					signfreightEntity.setPaymentStatus(2);
				}else{
					signfreightEntity.setPaymentStatus(0);
				}
				signfreightService.updateById(signfreightEntity);
				paymentdetialEntity.setPaidMoney(paymentdetialEntity.getDistributionMoney());
				paymentdetialEntity.setOutstandingMoney(paymentdetialEntity.getPaymentMoney().subtract(paymentdetialEntity.getDistributionMoney()));
				logger.info("---------已修改--------");
				paymentdetialService.updateById(paymentdetialEntity);
			}
		}
		logger.info("---------结束--------");
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
