package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 销售单信息
 * 
 * @author generator
 * 
 */
public class SalesorderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 工程主键
    private String projectName; // 工程名称
    private String customerId; // 客户id
    private String customerName; // 客户名称
    private Long worksiteId; // 工地主键
    private String worksiteName; // 工地名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date saleDate; // 销售日期
    private String remake; // 备注
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private Long profitcenterId; // 利润中心id
    private String profitcenterName; // 利润中心名称
    private BigDecimal salesTotalMoney; // 销售总金额
    private Integer isSign; // 是否签认: 0是1否
    private Integer isRefund; // 是否退款: 0是1否
    private Integer isReceivables; // 是否收款: 0是1否
    private Integer isDistribution; // 是否分配: 0是1否
    private BigDecimal receivedMoeny; // 已收金额
    private BigDecimal uncollectedMoeny; // 未收金额
    private BigDecimal accountAdjustmentMoeny; // 调账金额
    private BigDecimal distributionMoeny; // 已勾金额
    private Long signId; // 签认单id
    private Date signDate; // 签认日期
    private Date receivablesDate; // 收款日期
    private String receivablesTime; // 收款日期汇总
    private Long salesreconciliationId; // 销售调账单id
    private BigDecimal invoiceMoeny; // 发票已开金额
    private BigDecimal notInvoiceMoeny; // 发票未开金额
    private Integer isInvoice; // 是否已开发票: 0是1否
    private Integer salesorderType; // 销售类型 0-自动销售单  1-手动销售单 2-销售调账生成
    
    private List<SalesorderdetilsVO> salesorderdetilsList = new ArrayList<>(); // 销售单子表信息

    @ReferSerialTransfer(referCode="ProjectInfoRef")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    @ReferSerialTransfer(referCode="ConstructionsiteRef")
    public Long getWorksiteId() {
        return worksiteId;
    }

    @ReferDeserialTransfer
    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }
    public Date getSaleDate() {
        return saleDate;
    }

    public void setSaleDate(Date saleDate) {
        this.saleDate = saleDate;
    }
    public String getRemake() {
        return remake;
    }

    public void setRemake(String remake) {
        this.remake = remake;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="ProfitcenterRef")
    public Long getProfitcenterId() {
        return profitcenterId;
    }

    @ReferDeserialTransfer
    public void setProfitcenterId(Long profitcenterId) {
        this.profitcenterId = profitcenterId;
    }
    public String getProfitcenterName() {
        return profitcenterName;
    }

    public void setProfitcenterName(String profitcenterName) {
        this.profitcenterName = profitcenterName;
    }
    public BigDecimal getSalesTotalMoney() {
        return salesTotalMoney;
    }

    public void setSalesTotalMoney(BigDecimal salesTotalMoney) {
        this.salesTotalMoney = salesTotalMoney;
    }
    
     public List<SalesorderdetilsVO> getSalesorderdetilsList() {
        return salesorderdetilsList;
     }

     public void setSalesorderdetilsList(List<SalesorderdetilsVO> salesorderdetilsList) {
        this.salesorderdetilsList = salesorderdetilsList;
     }

    public Integer getIsSign() {
        return isSign;
    }

    public void setIsSign(Integer isSign) {
        this.isSign = isSign;
    }

    public Integer getIsRefund() {
        return isRefund;
    }

    public void setIsRefund(Integer isRefund) {
        this.isRefund = isRefund;
    }

    public Integer getIsDistribution() {
        return isDistribution;
    }

    public void setIsDistribution(Integer isDistribution) {
        this.isDistribution = isDistribution;
    }

    public BigDecimal getReceivedMoeny() {
        return receivedMoeny;
    }

    public void setReceivedMoeny(BigDecimal receivedMoeny) {
        this.receivedMoeny = receivedMoeny;
    }

    public BigDecimal getUncollectedMoeny() {
        return uncollectedMoeny;
    }

    public void setUncollectedMoeny(BigDecimal uncollectedMoeny) {
        this.uncollectedMoeny = uncollectedMoeny;
    }

    public BigDecimal getAccountAdjustmentMoeny() {
        return accountAdjustmentMoeny;
    }

    public void setAccountAdjustmentMoeny(BigDecimal accountAdjustmentMoeny) {
        this.accountAdjustmentMoeny = accountAdjustmentMoeny;
    }

    public BigDecimal getDistributionMoeny() {
        return distributionMoeny;
    }

    public void setDistributionMoeny(BigDecimal distributionMoeny) {
        this.distributionMoeny = distributionMoeny;
    }

    public Long getSignId() {
        return signId;
    }

    public void setSignId(Long signId) {
        this.signId = signId;
    }

    public Long getSalesreconciliationId() {
        return salesreconciliationId;
    }

    public void setSalesreconciliationId(Long salesreconciliationId) {
        this.salesreconciliationId = salesreconciliationId;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getReceivablesDate() {
        return receivablesDate;
    }

    public void setReceivablesDate(Date receivablesDate) {
        this.receivablesDate = receivablesDate;
    }

    public Integer getIsReceivables() {
        return isReceivables;
    }

    public void setIsReceivables(Integer isReceivables) {
        this.isReceivables = isReceivables;
    }

    public BigDecimal getInvoiceMoeny() {
        return invoiceMoeny;
    }

    public void setInvoiceMoeny(BigDecimal invoiceMoeny) {
        this.invoiceMoeny = invoiceMoeny;
    }

    public BigDecimal getNotInvoiceMoeny() {
        return notInvoiceMoeny;
    }

    public void setNotInvoiceMoeny(BigDecimal notInvoiceMoeny) {
        this.notInvoiceMoeny = notInvoiceMoeny;
    }

    public Integer getIsInvoice() {
        return isInvoice;
    }

    public void setIsInvoice(Integer isInvoice) {
        this.isInvoice = isInvoice;
    }

    public Integer getSalesorderType() {
        return salesorderType;
    }

    public void setSalesorderType(Integer salesorderType) {
        this.salesorderType = salesorderType;
    }

    public String getReceivablesTime() {
        return receivablesTime;
    }

    public void setReceivablesTime(String receivablesTime) {
        this.receivablesTime = receivablesTime;
    }
}
