package com.ejianc.business.sale.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.bean.SalesreconciliationEntity;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.ISalesreconciliationService;
import com.ejianc.business.sale.vo.SalesorderVO;
import com.ejianc.business.sale.vo.SalesreconciliationVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sale.bean.SignEntity;
import com.ejianc.business.sale.service.ISignService;
import com.ejianc.business.sale.vo.SignVO;

/**
 * 签认单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sign")
public class SignController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISignService service;
    @Autowired
    private ISalesorderService salesorderService;
    @Autowired
    private ISalesreconciliationService salesreconciliationService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    @Transactional
    public CommonResponse<SignVO> saveOrUpdate(@RequestBody SignVO saveOrUpdateVO) {
     	SignEntity entity = BeanMapper.map(saveOrUpdateVO, SignEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setSignStatus(1);
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //entity.setReceivablesMoney(entity.getBookTotalMoney().subtract(entity.getBookBalance()));
        entity.setSignMoney(new BigDecimal(0.00000000));
        entity.setSignBalance(entity.getBookTotalMoney());
        service.saveOrUpdate(entity, false);
        //没有调账单
        if(saveOrUpdateVO.getSalesreconciliationVO().size() == 0){
            for(SalesorderVO salesorderVO :saveOrUpdateVO.getSalesorderVO()){
                SalesorderEntity salesorderEntity = salesorderService.getById(salesorderVO.getId());
                if(salesorderEntity != null){
                    //将签认单id存入销售单中
                    salesorderEntity.setSignId(entity.getId());
                    salesorderEntity.setIsSign(2);
                    if(salesorderVO.getAccountAdjustmentMoeny() == null){
                        salesorderEntity.setAccountAdjustmentMoeny(new BigDecimal(0.00));
                    }else{
                        salesorderEntity.setAccountAdjustmentMoeny(salesorderVO.getAccountAdjustmentMoeny());
                    }
                    //salesorderEntity.setAccountAdjustmentMoeny(salesorderVO.getAccountAdjustmentMoeny());
                    salesorderService.updateById(salesorderEntity);
                }
            }
        }else{
            //收款金额 = 账面总额 - 调账单已勾金额
            entity.setReceivablesMoney(saveOrUpdateVO.getBookTotalMoney().subtract(saveOrUpdateVO.getSalesreconciliationVO().get(0).getDistributionMoeny()));
            //有调账单
            SalesreconciliationEntity salesreconciliationEntity = salesreconciliationService.getById(saveOrUpdateVO.getSalesreconciliationVO().get(0).getSalesreconciliationId());
            if(salesreconciliationEntity != null){
                salesreconciliationEntity.setSignId(entity.getId());
                salesreconciliationEntity.setDistributionMoeny(saveOrUpdateVO.getSalesreconciliationVO().get(0).getDistributionMoeny());
                salesreconciliationEntity.setStatus(2);
                salesreconciliationService.updateById(salesreconciliationEntity);
            }
            for(SalesorderVO salesorderVO : saveOrUpdateVO.getSalesorderVO()){
                SalesorderEntity salesorderEntity = salesorderService.getById(salesorderVO.getId());
                if(salesorderEntity != null){
                    salesorderEntity.setSignId(entity.getId());
                    salesorderEntity.setSalesreconciliationId(salesreconciliationEntity.getId());
                    //salesorderEntity.setAccountAdjustmentMoeny(salesorderVO.getAccountAdjustmentMoeny());
                    if(salesorderVO.getAccountAdjustmentMoeny() == null){
                        salesorderEntity.setAccountAdjustmentMoeny(new BigDecimal(0.00));
                    }else{
                        salesorderEntity.setAccountAdjustmentMoeny(salesorderVO.getAccountAdjustmentMoeny());
                    }
                    salesorderEntity.setIsSign(2);
                    salesorderService.updateById(salesorderEntity);
                }
            }
        }
    	SignVO vo = BeanMapper.map(entity, SignVO.class);
        QueryWrapper<SalesreconciliationEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sign_id",entity.getId());
        queryWrapper.eq("dr",0);
        queryWrapper.eq("status",2);
        List<SalesreconciliationVO> salesreconciliationVO = BeanMapper.mapList(salesreconciliationService.list(queryWrapper), SalesreconciliationVO.class);
        if(salesreconciliationVO != null){
            for(SalesreconciliationVO salesreconciliation : salesreconciliationVO){
                salesreconciliation.setSalesreconciliationId(salesreconciliation.getId());
                salesreconciliation.setAdjustmentBalance(salesreconciliation.getAdjustmentAmount().subtract(salesreconciliation.getDistributionMoeny()));
            }
            vo.setSalesreconciliationVO(salesreconciliationVO);
        }
        QueryWrapper<SalesorderEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("sign_id",entity.getId());
        queryWrapper1.eq("dr",0);
        queryWrapper1.eq("is_Sign",2);
        List<SalesorderVO> salesorderList = BeanMapper.mapList(salesorderService.list(queryWrapper1), SalesorderVO.class);
        if(salesorderList != null){
            vo.setSalesorderList(salesorderList);
        }
        QueryWrapper<SalesorderEntity> queryWrapper2 = new QueryWrapper<>();
        queryWrapper2.eq("customer_name",entity.getCustomerName());
        queryWrapper2.eq("dr",0);
        queryWrapper2.eq("is_Sign",1);
        List<SalesorderVO> salesorderVO = BeanMapper.mapList(salesorderService.list(queryWrapper2), SalesorderVO.class);
        if(salesorderVO != null){
            vo.setSalesorderVO(salesorderVO);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SignVO> queryDetail(Long id) {
    	SignEntity entity = service.selectById(id);
    	SignVO vo = BeanMapper.map(entity, SignVO.class);
        QueryWrapper<SalesreconciliationEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sign_id",entity.getId());
        queryWrapper.eq("dr",0);
        if(vo.getSignStatus().equals(1)){
            queryWrapper.eq("status",2);
        }else {
            queryWrapper.eq("status",1);
        }
        List<SalesreconciliationVO> salesreconciliationVO = BeanMapper.mapList(salesreconciliationService.list(queryWrapper), SalesreconciliationVO.class);
        if(salesreconciliationVO != null){
            for(SalesreconciliationVO salesreconciliation : salesreconciliationVO){
                salesreconciliation.setSalesreconciliationId(salesreconciliation.getId());
                salesreconciliation.setAdjustmentBalance(salesreconciliation.getAdjustmentAmount().subtract(salesreconciliation.getDistributionMoeny()));
            }
            vo.setSalesreconciliationVO(salesreconciliationVO);
        }
        QueryWrapper<SalesorderEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("sign_id",entity.getId());
        queryWrapper1.eq("dr",0);
        if(vo.getSignStatus().equals(1)){
            queryWrapper1.eq("is_Sign",2);
        }else{
            queryWrapper1.eq("is_Sign",0);
        }
        List<SalesorderVO> salesorderlist = BeanMapper.mapList(salesorderService.list(queryWrapper1), SalesorderVO.class);
        if(salesorderlist != null){
            vo.setSalesorderList(salesorderlist);
        }
        QueryWrapper<SalesorderEntity> queryWrapper2 = new QueryWrapper<>();
        queryWrapper2.eq("customer_name",entity.getCustomerName());
        queryWrapper2.eq("dr",0);
        queryWrapper2.eq("is_Sign",1);
        List<SalesorderVO> salesorderVO = BeanMapper.mapList(salesorderService.list(queryWrapper2), SalesorderVO.class);
        if(salesorderVO != null){
            vo.setSalesorderVO(salesorderVO);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SignVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SignVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SignVO::getId).collect(Collectors.toList()),true);
        for(SignVO signVO : vos){
            QueryWrapper<SalesorderEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("sign_id",signVO.getId());
            SalesorderEntity salesorderEntity = salesorderService.getOne(queryWrapper);
            salesorderEntity.setSignId(null);
            salesorderEntity.setSalesreconciliationId(null);
            salesorderEntity.setAccountAdjustmentMoeny(null);
            salesorderEntity.setIsSign(1);
            salesorderService.updateById(salesorderEntity);
            QueryWrapper<SalesreconciliationEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper.eq("sign_id",signVO.getId());
            SalesreconciliationEntity salesreconciliationEntity = salesreconciliationService.getOne(queryWrapper1);
            salesreconciliationEntity.setSignId(null);
            salesreconciliationEntity.setDistributionMoeny(null);
            salesreconciliationEntity.setStatus(0);
            salesreconciliationService.updateById(salesreconciliationEntity);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SignVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SignEntity> page = service.queryPage(param,false);
        IPage<SignVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SignVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SignEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Sign-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSignData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SignVO>> refSignData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SignEntity> page = service.queryPage(param,false);
        IPage<SignVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SignVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 初始化更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "signId")
    @ResponseBody
    public CommonResponse<SignVO> signId(@RequestParam(value = "signId") Long signId) {
        SignEntity signEntity = service.selectById(signId);
        signEntity.setSignMoney(signEntity.getSignBalance());
        //signEntity.setSignBalance(signEntity.getSignBalance().subtract(signEntity.getSignBalance()));
        SignVO signVO = BeanMapper.map(signEntity, SignVO.class);
        QueryWrapper<SalesreconciliationEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sign_id",signEntity.getId());
        queryWrapper.eq("dr",0);
        queryWrapper.eq("status",2);
        List<SalesreconciliationVO> salesreconciliationVO = BeanMapper.mapList(salesreconciliationService.list(queryWrapper), SalesreconciliationVO.class);
        if(salesreconciliationVO != null){
            for(SalesreconciliationVO salesreconciliation : salesreconciliationVO){
                salesreconciliation.setSalesreconciliationId(salesreconciliation.getId());
                salesreconciliation.setAdjustmentBalance(salesreconciliation.getAdjustmentAmount().subtract(salesreconciliation.getDistributionMoeny().abs()));
            }
            signVO.setSalesreconciliationVO(salesreconciliationVO);
        }
        QueryWrapper<SalesorderEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("sign_id",signEntity.getId());
        queryWrapper1.eq("dr",0);
        queryWrapper1.eq("is_Sign",2);
        List<SalesorderVO> salesorderlist = BeanMapper.mapList(salesorderService.list(queryWrapper1), SalesorderVO.class);
        if(salesorderlist != null){
            signVO.setSalesorderList(salesorderlist);
        }
        return CommonResponse.success("查询详情成功！", signVO);

    }
    /**
     * @Description sign 签认
     */
    @RequestMapping(value = "/sign", method = RequestMethod.POST)
    @ResponseBody
    @Transactional
    public CommonResponse<SignVO> saveSign(@RequestBody SignVO saveVO) {
        SignEntity entity = service.getById(saveVO.getId());
        entity.setSignMoney(saveVO.getSignMoney());
        entity.setSignBalance(new BigDecimal(0.00));
        entity.setSignStatus(0);
        entity.setSignTime(new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());//设置起时间
        cal.add(Calendar.YEAR, 2);//增加一年
        entity.setFailureTime(cal.getTime());
        service.updateById(entity);
        if(saveVO.getSalesreconciliationVO().size() > 0){
           SalesreconciliationEntity salesreconciliationEntity = salesreconciliationService.getById(saveVO.getSalesreconciliationVO().get(0).getSalesreconciliationId());
            salesreconciliationEntity.setAdjustmentBalance(salesreconciliationEntity.getAdjustmentAmount().subtract(salesreconciliationEntity.getDistributionMoeny()));
           if(salesreconciliationEntity.getAdjustmentBalance().doubleValue() == 0.00){
               salesreconciliationEntity.setStatus(1);
           }
            salesreconciliationService.updateById(salesreconciliationEntity);
        }
        if(saveVO.getSalesorderList().size() > 0){
            for (SalesorderVO salesorderVO : saveVO.getSalesorderList()){
                SalesorderEntity salesorderEntity = salesorderService.getById(salesorderVO.getId());
                salesorderEntity.setIsSign(0);
                salesorderEntity.setSignDate(new Date());
                salesorderEntity.setReceivedMoeny(new BigDecimal(0.00));
                salesorderEntity.setInvoiceMoeny(new BigDecimal(0.00));
                if(salesorderEntity.getAccountAdjustmentMoeny() != null){
                    salesorderEntity.setUncollectedMoeny(salesorderEntity.getSalesTotalMoney().subtract(salesorderEntity.getAccountAdjustmentMoeny()));
                    salesorderEntity.setNotInvoiceMoeny(salesorderEntity.getSalesTotalMoney().subtract(salesorderEntity.getAccountAdjustmentMoeny()));
                }
                salesorderService.updateById(salesorderEntity);
            }
        }
        SignVO vo = BeanMapper.map(entity, SignVO.class);
        QueryWrapper<SalesreconciliationEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sign_id",entity.getId());
        queryWrapper.eq("dr",0);
        queryWrapper.eq("status",1);
        List<SalesreconciliationVO> salesreconciliationVO = BeanMapper.mapList(salesreconciliationService.list(queryWrapper), SalesreconciliationVO.class);
        if(salesreconciliationVO != null){
            vo.setSalesreconciliationVO(salesreconciliationVO);
        }
        QueryWrapper<SalesorderEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("sign_id",entity.getId());
        queryWrapper1.eq("dr",0);
        queryWrapper1.eq("is_Sign",0);
        List<SalesorderVO> salesorderlist = BeanMapper.mapList(salesorderService.list(queryWrapper1), SalesorderVO.class);
        if(salesorderlist != null){
            vo.setSalesorderList(salesorderlist);
        }


        return CommonResponse.success("签认成功！",vo);
    }
}
