package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 销售调账
 * 
 * @author generator
 * 
 */
public class SalesreconciliationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long customerId; // 客户主键
    private String customerName; // 客户名称
    private Long projectId; // 工程主键
    private String projectName; // 工程名称
    private Long productId; // 产品主键
    private String productName; // 产品名称
    private BigDecimal totalAmount; // 总金额
    private BigDecimal uncollectedAmount; // 剩余未收金额
    private BigDecimal adjustmentAmount; // 调账金额
    private BigDecimal adjustmentBalance; // 调账余额
    private BigDecimal amountAfterAdjustment; // 调账后金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date; // 业务发生所属日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date entryDate; // 录时间入
    private String reason; // 调账原因
    private Long profitcenterId; // 利润中心主键
    private String profitcenterName; // 利润中心名称
    private Integer status; // 调账状态:1确认0驳回2调账中
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private BigDecimal distributionMoeny; // 已勾金额
    private Long signId; // 签认单id

    private Long salesreconciliationId; // 销售调账单id

    private List<SalesorderVO> salesorderVO  = new ArrayList<>();//销售单子表

    public List<SalesorderVO> getSalesorderVO() {
        return salesorderVO;
    }

    public void setSalesorderVO(List<SalesorderVO> salesorderVO) {
        this.salesorderVO = salesorderVO;
    }

    @ReferSerialTransfer(referCode="CustomermanageRef")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    @ReferSerialTransfer(referCode="ProjectInfoRef")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="ProductorInfoRef")
    public Long getProductId() {
        return productId;
    }

    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
    public BigDecimal getUncollectedAmount() {
        return uncollectedAmount;
    }

    public void setUncollectedAmount(BigDecimal uncollectedAmount) {
        this.uncollectedAmount = uncollectedAmount;
    }
    public BigDecimal getAdjustmentAmount() {
        return adjustmentAmount;
    }

    public void setAdjustmentAmount(BigDecimal adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }
    public BigDecimal getAdjustmentBalance() {
        return adjustmentBalance;
    }

    public void setAdjustmentBalance(BigDecimal adjustmentBalance) {
        this.adjustmentBalance = adjustmentBalance;
    }
    public BigDecimal getAmountAfterAdjustment() {
        return amountAfterAdjustment;
    }

    public void setAmountAfterAdjustment(BigDecimal amountAfterAdjustment) {
        this.amountAfterAdjustment = amountAfterAdjustment;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public Date getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
    @ReferSerialTransfer(referCode="ProfitcenterRef")
    public Long getProfitcenterId() {
        return profitcenterId;
    }

    @ReferDeserialTransfer
    public void setProfitcenterId(Long profitcenterId) {
        this.profitcenterId = profitcenterId;
    }
    public String getProfitcenterName() {
        return profitcenterName;
    }

    public void setProfitcenterName(String profitcenterName) {
        this.profitcenterName = profitcenterName;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getDistributionMoeny() {
        return distributionMoeny;
    }

    public void setDistributionMoeny(BigDecimal distributionMoeny) {
        this.distributionMoeny = distributionMoeny;
    }

    public Long getSignId() {
        return signId;
    }

    public void setSignId(Long signId) {
        this.signId = signId;
    }

    public Long getSalesreconciliationId() {
        return salesreconciliationId;
    }

    public void setSalesreconciliationId(Long salesreconciliationId) {
        this.salesreconciliationId = salesreconciliationId;
    }
}
