package com.ejianc.business.sale.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 签认单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sale_sign")
public class SignEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 工程主键
    @TableField(value="project_name")
    private String projectName; // 工程名称
    @TableField(value="customer_id")
    private Long customerId; // 客户名称
    @TableField(value="customer_name")
    private String customerName; // 客户名称
    @TableField(value="worksite_id")
    private Long worksiteId; // 工地主键
    @TableField(value="worksite_name")
    private String worksiteName; // 工地名称
    @TableField(value="profitcenter_id")
    private Long profitcenterId; // 利润中心id
    @TableField(value="profitcenter_name")
    private String profitcenterName; // 利润中心名称
    @TableField(value="book_total_money")
    private BigDecimal bookTotalMoney; // 账面总额
    @TableField(value="receivables_money")
    private BigDecimal receivablesMoney; // 收款金额
    @TableField(value="book_balance")
    private BigDecimal bookBalance; // 账面余额
    @TableField(value="sign_money")
    private BigDecimal signMoney; // 签认金额
    @TableField(value="sign_balance")
    private BigDecimal signBalance; // 签认余额
    @TableField(value="sign_time")
    private Date signTime; // 签认日期
    @TableField(value="failure_time")
    private Date failureTime; // 失效日期
    @TableField(value="sign_status")
    private Integer signStatus; // 签认状态 0-已签认,1-未签认
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="is_Sign")
    private Integer isSign; // 是否签认: 0是1否
    @TableField(value="is_refund")
    private Integer isRefund; // 是否退款: 0是1否
    @TableField(value="is_distribution")
    private Integer isDistribution; // 是否分配: 0是1否
    
    
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getWorksiteId() {
        return worksiteId;
    }

    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }
    public Long getProfitcenterId() {
        return profitcenterId;
    }

    public void setProfitcenterId(Long profitcenterId) {
        this.profitcenterId = profitcenterId;
    }
    public String getProfitcenterName() {
        return profitcenterName;
    }

    public void setProfitcenterName(String profitcenterName) {
        this.profitcenterName = profitcenterName;
    }
    public BigDecimal getBookTotalMoney() {
        return bookTotalMoney;
    }

    public void setBookTotalMoney(BigDecimal bookTotalMoney) {
        this.bookTotalMoney = bookTotalMoney;
    }
    public BigDecimal getReceivablesMoney() {
        return receivablesMoney;
    }

    public void setReceivablesMoney(BigDecimal receivablesMoney) {
        this.receivablesMoney = receivablesMoney;
    }
    public BigDecimal getBookBalance() {
        return bookBalance;
    }

    public void setBookBalance(BigDecimal bookBalance) {
        this.bookBalance = bookBalance;
    }
    public BigDecimal getSignMoney() {
        return signMoney;
    }

    public void setSignMoney(BigDecimal signMoney) {
        this.signMoney = signMoney;
    }
    public BigDecimal getSignBalance() {
        return signBalance;
    }

    public void setSignBalance(BigDecimal signBalance) {
        this.signBalance = signBalance;
    }
    public Date getSignTime() {
        return signTime;
    }

    public void setSignTime(Date signTime) {
        this.signTime = signTime;
    }
    public Date getFailureTime() {
        return failureTime;
    }

    public void setFailureTime(Date failureTime) {
        this.failureTime = failureTime;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getIsSign() {
        return isSign;
    }

    public void setIsSign(Integer isSign) {
        this.isSign = isSign;
    }
    public Integer getIsRefund() {
        return isRefund;
    }

    public void setIsRefund(Integer isRefund) {
        this.isRefund = isRefund;
    }
    public Integer getIsDistribution() {
        return isDistribution;
    }

    public void setIsDistribution(Integer isDistribution) {
        this.isDistribution = isDistribution;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
}
