package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sale.bean.*;
import com.ejianc.business.sale.service.IInvoiceService;
import com.ejianc.business.sale.service.IInvoicedetialService;
import com.ejianc.business.sale.service.IReceivablessummaryService;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.vo.ReceivablessummaryVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Service("invoice") 
public class InvoiceBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IInvoiceService invoiceService;
	@Autowired
	private IInvoicedetialService invoicedetialService;
	@Autowired
	private IReceivablessummaryService receivablessummaryService;
	@Autowired
	private ISalesorderService salesorderService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		InvoiceEntity invoiceEntity = invoiceService.selectById(billId);
		QueryWrapper<InvoicedetialEntity> queryWrapper = new QueryWrapper();
		queryWrapper.select("DISTINCT receivables_time");
		queryWrapper.eq("mid",invoiceEntity.getId());
		List<InvoicedetialEntity> invoicedetialList = invoicedetialService.list(queryWrapper);
		for (InvoicedetialEntity invoicedetialEntity :invoicedetialList){
			QueryWrapper<InvoicedetialEntity> wrapper = new QueryWrapper<>();
			wrapper.eq("mid", invoiceEntity.getId());
			wrapper.eq("receivables_time",invoicedetialEntity.getReceivablesTime());
			wrapper.select("sum(distribution_money) as total ");
			Map<String, Object> map = invoicedetialService.getMap(wrapper);
			Double total = Double.valueOf(String.valueOf(map.get("total")));
			ReceivablessummaryEntity receivablessummaryVO = new ReceivablessummaryEntity();
			receivablessummaryVO.setMid(invoiceEntity.getId());
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
			try {
				receivablessummaryVO.setConsignmentDate(sdf.parse(invoicedetialEntity.getReceivablesTime()));
			} catch (ParseException e) {
				e.printStackTrace();
			};
			receivablessummaryVO.setSummaryMoney(BigDecimal.valueOf(total));
			receivablessummaryService.saveOrUpdate(receivablessummaryVO,false);
		}




		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("---------进来啦--------");
		InvoiceEntity invoiceEntity = invoiceService.selectById(billId);
		if(invoiceEntity.getInvoicedetialList()!= null){
			logger.info("---------不为空--------");
			for(InvoicedetialEntity invoicedetial : invoiceEntity.getInvoicedetialList()){
				SalesorderEntity salesorderEntity = salesorderService.getById(invoicedetial.getSaleId());
				salesorderEntity.setInvoiceMoeny(invoicedetial.getDistributionMoney().add(salesorderEntity.getInvoiceMoeny()));
				salesorderEntity.setNotInvoiceMoeny(salesorderEntity.getNotInvoiceMoeny().subtract(invoicedetial.getDistributionMoney()));
				if (salesorderEntity.getNotInvoiceMoeny().doubleValue() == 0.00){
					salesorderEntity.setIsInvoice(0);
				}else {
					salesorderEntity.setIsInvoice(1);
				}
				logger.info("---------已修改1--------");
				salesorderService.updateById(salesorderEntity);
				invoicedetial.setReceivedMoney(invoicedetial.getDistributionMoney());
				invoicedetial.setUncollectedMoney(invoicedetial.getInvoiceMoney().subtract(invoicedetial.getDistributionMoney().add(invoicedetial.getOtherReceivedMoney())));
				logger.info("---------已修改2--------");
				invoicedetialService.updateById(invoicedetial);
			}
		}
		logger.info("---------结束--------");
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
