package com.ejianc.business.sale.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.sale.bean.InvoicedetialEntity;
/**
 * 发票管理
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sale_invoice")
public class InvoiceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="customer_id")
    private Long customerId; // 客户主键
    @TableField(value="customer_name")
    private String customerName; // 客户名称
    @TableField(value="profitcenter_id")
    private Long profitcenterId; // 利润中心id
    @TableField(value="profitcenter_name")
    private String profitcenterName; // 利润中心名称
    @TableField(value="invoice_money")
    private BigDecimal invoiceMoney; // 发票金额
    @TableField(value="balance_money")
    private BigDecimal balanceMoney; // 发票余额金额
    @TableField(value="receivables_type")
    private Long receivablesType; // 收款类型id
    @TableField(value="checkout_time")
    private Date checkoutTime; // 结账年月日
    @TableField(value="invoices_status")
    private Integer invoicesStatus; // 发票状态
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="abstracts")
    private String abstracts; // 摘要
    @TableField(value="is_sale")
    private Integer isSale; // 是否关联销售单
    @TableField(value="stay_distribution_money")
    private BigDecimal stayDistributionMoney; // 已开待分配金额
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="invoicedetialService",pidName = "mid")
    private List<InvoicedetialEntity> invoicedetialList = new ArrayList<>(); // 发票管理子表
    @TableField(exist=false)
    @SubEntity(serviceName="receivablessummaryService",pidName = "mid")
    private List<ReceivablessummaryEntity> receivablessummaryList = new ArrayList<>(); // 付款汇总管理子表
    @TableField(exist=false)
    @SubEntity(serviceName="receivablesinvoiceService",pidName = "mid")
    private List<ReceivablesinvoiceEntity> receivablesinvoicelist = new ArrayList<>(); // 付款开票子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getProfitcenterId() {
        return profitcenterId;
    }

    public void setProfitcenterId(Long profitcenterId) {
        this.profitcenterId = profitcenterId;
    }
    public String getProfitcenterName() {
        return profitcenterName;
    }

    public void setProfitcenterName(String profitcenterName) {
        this.profitcenterName = profitcenterName;
    }
    public BigDecimal getInvoiceMoney() {
        return invoiceMoney;
    }

    public void setInvoiceMoney(BigDecimal invoiceMoney) {
        this.invoiceMoney = invoiceMoney;
    }
    public BigDecimal getBalanceMoney() {
        return balanceMoney;
    }

    public void setBalanceMoney(BigDecimal balanceMoney) {
        this.balanceMoney = balanceMoney;
    }
    public Long getReceivablesType() {
        return receivablesType;
    }

    public void setReceivablesType(Long receivablesType) {
        this.receivablesType = receivablesType;
    }
    public Date getCheckoutTime() {
        return checkoutTime;
    }

    public void setCheckoutTime(Date checkoutTime) {
        this.checkoutTime = checkoutTime;
    }
    public Integer getInvoicesStatus() {
        return invoicesStatus;
    }

    public void setInvoicesStatus(Integer invoicesStatus) {
        this.invoicesStatus = invoicesStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }
    

    public List<InvoicedetialEntity> getInvoicedetialList() {
        return invoicedetialList;
    }

    public void setInvoicedetialList(List<InvoicedetialEntity> invoicedetialList) {
        this.invoicedetialList = invoicedetialList;
    }

    public List<ReceivablessummaryEntity> getReceivablessummaryList() {
        return receivablessummaryList;
    }

    public void setReceivablessummaryList(List<ReceivablessummaryEntity> receivablessummaryList) {
        this.receivablessummaryList = receivablessummaryList;
    }

    public List<ReceivablesinvoiceEntity> getReceivablesinvoicelist() {
        return receivablesinvoicelist;
    }

    public void setReceivablesinvoicelist(List<ReceivablesinvoiceEntity> receivablesinvoicelist) {
        this.receivablesinvoicelist = receivablesinvoicelist;
    }

    public Integer getIsSale() {
        return isSale;
    }

    public void setIsSale(Integer isSale) {
        this.isSale = isSale;
    }

    public BigDecimal getStayDistributionMoney() {
        return stayDistributionMoney;
    }

    public void setStayDistributionMoney(BigDecimal stayDistributionMoney) {
        this.stayDistributionMoney = stayDistributionMoney;
    }
}
