package com.ejianc.business.sale.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.sale.bean.OpeninvoicedetialEntity;
/**
 * 开票信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sale_openinvoice")
public class OpeninvoiceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="transport_id")
    private Long transportId; // 运输商主键
    @TableField(value="transport_name")
    private String transportName; // 运输商名称
    @TableField(value="openinvoice_money")
    private BigDecimal openinvoiceMoney; // 开票金额
    @TableField(value="not_openinvoice_money")
    private BigDecimal notOpeninvoiceMoney; // 未开票金额
    @TableField(value="settlement_type")
    private Long settlementType; // 结算方式id
    @TableField(value="settlement_name")
    private String settlementName; // 结算方式名称
    @TableField(value="openinvoice_time")
    private Date openinvoiceTime; // 开票日期
    @TableField(value="openinvoice_status")
    private Integer openinvoiceStatus; // 开票状态
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="abstracts")
    private String abstracts; // 摘要
    @TableField(value="balance")
    private BigDecimal balance; // 历史余额
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="openinvoicedetialService",pidName = "mid")
    private List<OpeninvoicedetialEntity> openinvoicedetialList = new ArrayList<>(); // 开票信息子表
    @TableField(exist=false)
    @SubEntity(serviceName="openinvoicedetailsService",pidName = "mid")
    private List<OpeninvoicedetailsEntity> openinvoicedetailsList = new ArrayList<>(); // 开票信息子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getTransportId() {
        return transportId;
    }

    public void setTransportId(Long transportId) {
        this.transportId = transportId;
    }
    public String getTransportName() {
        return transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }
    public BigDecimal getOpeninvoiceMoney() {
        return openinvoiceMoney;
    }

    public void setOpeninvoiceMoney(BigDecimal openinvoiceMoney) {
        this.openinvoiceMoney = openinvoiceMoney;
    }
    public BigDecimal getNotOpeninvoiceMoney() {
        return notOpeninvoiceMoney;
    }

    public void setNotOpeninvoiceMoney(BigDecimal notOpeninvoiceMoney) {
        this.notOpeninvoiceMoney = notOpeninvoiceMoney;
    }
    public Long getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Long settlementType) {
        this.settlementType = settlementType;
    }
    public String getSettlementName() {
        return settlementName;
    }

    public void setSettlementName(String settlementName) {
        this.settlementName = settlementName;
    }
    public Date getOpeninvoiceTime() {
        return openinvoiceTime;
    }

    public void setOpeninvoiceTime(Date openinvoiceTime) {
        this.openinvoiceTime = openinvoiceTime;
    }
    public Integer getOpeninvoiceStatus() {
        return openinvoiceStatus;
    }

    public void setOpeninvoiceStatus(Integer openinvoiceStatus) {
        this.openinvoiceStatus = openinvoiceStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }
    

    public List<OpeninvoicedetialEntity> getOpeninvoicedetialList() {
        return openinvoicedetialList;
    }

    public void setOpeninvoicedetialList(List<OpeninvoicedetialEntity> openinvoicedetialList) {
        this.openinvoicedetialList = openinvoicedetialList;
    }

    public List<OpeninvoicedetailsEntity> getOpeninvoicedetailsList() {
        return openinvoicedetailsList;
    }

    public void setOpeninvoicedetailsList(List<OpeninvoicedetailsEntity> openinvoicedetailsList) {
        this.openinvoicedetailsList = openinvoicedetailsList;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }
}
