package com.ejianc.business.sale.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sale.bean.ManualshipmentEntity;
import com.ejianc.business.sale.salesorder.vo.MasterVO;
import com.ejianc.business.sale.salesorder.vo.ProductiontasktransportVO;
import com.ejianc.business.sale.service.IManualshipmentService;
import com.ejianc.business.sale.vo.ManualshipmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/6/7
 * @description:分配车辆保存时直接生成发货管理
 */
@RestController
@RequestMapping("/api/sale/generateManualshipment")
public class GenerateManualshipmentApi implements Serializable {
    @Autowired
    private IManualshipmentService service;
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "sale-manualshipment";//此处需要根据实际修改

    /**
     * 生成发货管理
     */
    @PostMapping(value = "/savelist")
    public CommonResponse saveList(@RequestBody List<ProductiontasktransportVO> voList){
        if (!voList.isEmpty()){
            List<ManualshipmentVO> manualshipmentVOS=new ArrayList<>();
            for (ProductiontasktransportVO productiontasktransportVO : voList) {
                ManualshipmentVO manualshipmentVO = new ManualshipmentVO();
                manualshipmentVO.setCarId(productiontasktransportVO.getShippersVehicleId());
                manualshipmentVO.setNumberPlateId(productiontasktransportVO.getProductId());
                manualshipmentVO.setNumberPlate(productiontasktransportVO.getShippersVehicleCode());
                manualshipmentVO.setCustomerId(productiontasktransportVO.getCustomerManageId());
                manualshipmentVO.setCustomerName(productiontasktransportVO.getCustomerManageName());
                manualshipmentVO.setProjectId(productiontasktransportVO.getProjectId());
                manualshipmentVO.setProjectName(productiontasktransportVO.getProjectName());
                manualshipmentVO.setProductName(productiontasktransportVO.getProductName());
                manualshipmentVO.setProductId(productiontasktransportVO.getProductId());
                manualshipmentVO.setWorksiteId(productiontasktransportVO.getWorksiteId());
                manualshipmentVO.setWorksiteName(productiontasktransportVO.getWorksiteName());
                manualshipmentVO.setUnitId(productiontasktransportVO.getUnitId());
                manualshipmentVO.setUnitName(productiontasktransportVO.getUnitName());
                manualshipmentVO.setShipDate(productiontasktransportVO.getTransportTime());
                manualshipmentVO.setShipDates(productiontasktransportVO.getTransportTime());
                manualshipmentVO.setTare(productiontasktransportVO.getTare());
                manualshipmentVO.setGrossWeight(productiontasktransportVO.getTransportCount());
                manualshipmentVO.setNetWeight(productiontasktransportVO.getTransportCount());
                manualshipmentVO.setShippingMethod(1);
                manualshipmentVO.setShippersId(productiontasktransportVO.getShippersId());
                manualshipmentVO.setShippersName(productiontasktransportVO.getShippersName());
                manualshipmentVO.setDistance(productiontasktransportVO.getDistance());
                manualshipmentVO.setFreight(new BigDecimal("0"));
                manualshipmentVO.setOrgId(productiontasktransportVO.getOrgId());
                manualshipmentVO.setOrgName(productiontasktransportVO.getOrgName());
                manualshipmentVO.setTaskId(productiontasktransportVO.getTaskId().toString());
                manualshipmentVO.setUnitdistributeId(productiontasktransportVO.getUnitdistributeId().toString());
                manualshipmentVO.setShipmentType(0);
                manualshipmentVO.setFreightStatus(1);
                manualshipmentVO.setReceiptStatus(1);
                manualshipmentVO.setTransportRoute(productiontasktransportVO.getTransportRoute());
                manualshipmentVO.setOrderName(productiontasktransportVO.getOrderName());
                manualshipmentVO.setOrderMobile(productiontasktransportVO.getOrderMobile());
                manualshipmentVO.setPrintCustomer(productiontasktransportVO.getPrintCustomerName());
                manualshipmentVO.setPrintConstruction(productiontasktransportVO.getPrintWorksiteName());
                manualshipmentVO.setPrintProducts(productiontasktransportVO.getPrintProductName());
                manualshipmentVO.setPrintSupplier(productiontasktransportVO.getPrintSupplyName());
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),manualshipmentVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    manualshipmentVO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                manualshipmentVOS.add(manualshipmentVO);
            }
            List<ManualshipmentEntity> manualshipmentEntities = BeanMapper.mapList(manualshipmentVOS, ManualshipmentEntity.class);
            service.saveOrUpdateBatch(manualshipmentEntities,manualshipmentEntities.size(),false);
        }
        return CommonResponse.success("生成发货管理成功");
    }

    /**
     * 查询净重总和
     * @param
     * @return
     */
    @PostMapping(value = "/querynetWeight")
    public CommonResponse<BigDecimal> queryNetWeight(Long unitDistributeId){
        QueryWrapper queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("unitdistribute_id",unitDistributeId);
        List<ManualshipmentEntity> list = service.list(queryWrapper);
        BigDecimal netWeight=new BigDecimal("0");
        if (!list.isEmpty()) {
            for (ManualshipmentEntity manualshipmentEntity : list) {
                netWeight = netWeight.add(manualshipmentEntity.getNetWeight());
            }
        }
        return CommonResponse.success("查询净重成功",netWeight);
    }
}
