package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.bean.ReceivablesEntity;
import com.ejianc.business.sale.mapper.ProjectInfoMapper;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sale.mapper.InvoiceMapper;
import com.ejianc.business.sale.bean.InvoiceEntity;
import com.ejianc.business.sale.service.IInvoiceService;

/**
 * 发票管理
 * 
 * @author generator
 * 
 */
@Service("invoiceService")
public class InvoiceServiceImpl extends BaseServiceImpl<InvoiceMapper, InvoiceEntity> implements IInvoiceService{

    @Autowired
    private ProjectInfoMapper projectInfoMapper;

    @Override
    public IPage<InvoiceEntity> getInvoice(QueryParam param) {
        IPage<InvoiceEntity> page = new Page<>();
        page.setSize(param.getPageSize());
        page.setCurrent(param.getPageIndex());
        IPage<InvoiceEntity> page1 = this.projectInfoMapper.getInvoice(page, new QueryWrapper<InvoiceEntity>()
                .eq("tenant_id",param.getParams().get("tenantId").getValue())
                .eq("dr","0")
                .eq("sale_id",param.getParams().get("saleId").getValue())
                .orderByDesc("create_time"));
        return page1;
    }

}
