package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.service.IProjectInfoService;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sale.mapper.ProjectInfoMapper;
import com.ejianc.business.sale.bean.ProjectInfoEntity;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 工程管理
 * 
 * @author generator
 * 
 */
@Service("projectInfoService")
public class ProjectInfoServiceImpl extends BaseServiceImpl<ProjectInfoMapper, ProjectInfoEntity> implements IProjectInfoService {


    @Override
    public IPage<ProjectInfoEntity> getSelect(QueryParam param) {
        IPage<ProjectInfoEntity> page = new Page<>();
        page.setSize(param.getPageSize());
        page.setCurrent(param.getPageIndex());
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String time = sdf.format(date);
        IPage<ProjectInfoEntity> page1 = this.baseMapper.getSelect(page,
                new QueryWrapper<ProjectInfoEntity>()
                        .eq("product_id",param.getParams().get("productId").getValue())
                        .eq("org_id",param.getParams().get("org").getValue())
                        .eq("tenant_id",param.getParams().get("tenantId").getValue())
                        .eq("dr","0")
                        .lt("project_start_time",time)
                        .gt("project_end_time",time));
        return page1;
    }
}
