package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 发货管理
 * 
 * @author generator
 * 
 */
public class ManualshipmentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long customerId; // 客户主键
    private String customerName; // 客户名称
    private Long projectId; // 工程主键
    private String projectName; // 工程名称
    private Long worksiteId; // 工地主键
    private String worksiteName; // 工地名称
    private Long unitId; // 机组主键
    private String unitName; // 机组名称
    private Long productId; // 产品主键
    private String productName; // 产品名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date shipDate; // 发货日期
    private Date shipDates; // 发货日期年月日
    private Long temperature; // 温度
    private Long carId; // 车辆主键
    private Long numberPlateId; // 车号id
    private String numberPlate; // 车号
    private BigDecimal tare; // 皮重
    private String receipts; // 收款情况
    private BigDecimal grossWeight; // 毛重
    private BigDecimal netWeight; // 净重
    private Integer shippingMethod; // 运输方式:0代运1自运
    private Long shippersId; // 运输单位主键
    private String shippersName; // 运输单位名称
    private BigDecimal distance; // 运输距离
    private BigDecimal freight; // 运费
    private String remake; // 备注
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private Integer shipmentType; // 发货类型  0-手动发货 1-自动发货
    private Integer freightStatus; // 运费确认标志  0-已确认 1-未确认
    private Date freightTime; // 运费确认时间
    private BigDecimal confirmNumber; // 确认数
    private Integer receiptStatus; // 回执单状态  0-已勾  1-未勾
    private BigDecimal paidMoney; // 已付运费
    private BigDecimal outstandingMoney; // 未付运费
    private String transportRoute; // 行车路线
    private String orderName; // 联系人
    private String orderMobile; // 联系电话
    private String inspection; // 检验
    private String printCustomer; // 打印客户名
    private String printConstruction; // 打印工地名称
    private String printProducts; // 打印产品名
    private String printSupplier; // 打印供货商
    private String printShippersName; // 打印运输商名称
    private String reason; // 变更原因
    private String abstracts; // 确认数备注
    private String taskId; // 生产任务单id
    private String unitdistributeId; // 分配机组id
    private String oldTaskId; // 老erp系统生产任务编号


    @ReferSerialTransfer(referCode="CustomermanageRef")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    @ReferSerialTransfer(referCode="ProjectInfoRef")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="ConstructionsiteRef")
    public Long getWorksiteId() {
        return worksiteId;
    }

    @ReferDeserialTransfer
    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }
    @ReferSerialTransfer(referCode="UnitRef")
    public Long getUnitId() {
        return unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    @ReferSerialTransfer(referCode="ProductorInfoRef")
    public Long getProductId() {
        return productId;
    }

    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public Date getShipDate() {
        return shipDate;
    }

    public void setShipDate(Date shipDate) {
        this.shipDate = shipDate;
    }
    public Long getTemperature() {
        return temperature;
    }

    public void setTemperature(Long temperature) {
        this.temperature = temperature;
    }
    @ReferSerialTransfer(referCode="ShippersVehicleRef")
    public Long getCarId() {
        return carId;
    }

    @ReferDeserialTransfer
    public void setCarId(Long carId) {
        this.carId = carId;
    }
    public String getNumberPlate() {
        return numberPlate;
    }

    public void setNumberPlate(String numberPlate) {
        this.numberPlate = numberPlate;
    }
    public BigDecimal getTare() {
        return tare;
    }

    public void setTare(BigDecimal tare) {
        this.tare = tare;
    }
    public String getReceipts() {
        return receipts;
    }

    public void setReceipts(String receipts) {
        this.receipts = receipts;
    }
    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }
    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }
    public Integer getShippingMethod() {
        return shippingMethod;
    }

    public void setShippingMethod(Integer shippingMethod) {
        this.shippingMethod = shippingMethod;
    }
    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getShippersId() {
        return shippersId;
    }

    @ReferDeserialTransfer
    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }
    public BigDecimal getDistance() {
        return distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }
    public BigDecimal getFreight() {
        return freight;
    }

    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }
    public String getRemake() {
        return remake;
    }

    public void setRemake(String remake) {
        this.remake = remake;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getShipmentType() {
        return shipmentType;
    }

    public void setShipmentType(Integer shipmentType) {
        this.shipmentType = shipmentType;
    }

    public Integer getFreightStatus() {
        return freightStatus;
    }

    public void setFreightStatus(Integer freightStatus) {
        this.freightStatus = freightStatus;
    }

    public Date getFreightTime() {
        return freightTime;
    }

    public void setFreightTime(Date freightTime) {
        this.freightTime = freightTime;
    }

    public BigDecimal getConfirmNumber() {
        return confirmNumber;
    }

    public void setConfirmNumber(BigDecimal confirmNumber) {
        this.confirmNumber = confirmNumber;
    }

    public Integer getReceiptStatus() {
        return receiptStatus;
    }

    public void setReceiptStatus(Integer receiptStatus) {
        this.receiptStatus = receiptStatus;
    }

    public BigDecimal getPaidMoney() {
        return paidMoney;
    }

    public void setPaidMoney(BigDecimal paidMoney) {
        this.paidMoney = paidMoney;
    }

    public BigDecimal getOutstandingMoney() {
        return outstandingMoney;
    }

    public void setOutstandingMoney(BigDecimal outstandingMoney) {
        this.outstandingMoney = outstandingMoney;
    }

    @ReferSerialTransfer(referCode="ProductiontasktransportRef")
    public Long getNumberPlateId() {
        return numberPlateId;
    }

    @ReferDeserialTransfer
    public void setNumberPlateId(Long numberPlateId) {
        this.numberPlateId = numberPlateId;
    }

    public String getTransportRoute() {
        return transportRoute;
    }

    public void setTransportRoute(String transportRoute) {
        this.transportRoute = transportRoute;
    }

    public String getOrderName() {
        return orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }

    public String getOrderMobile() {
        return orderMobile;
    }

    public void setOrderMobile(String orderMobile) {
        this.orderMobile = orderMobile;
    }

    public String getInspection() {
        return inspection;
    }

    public void setInspection(String inspection) {
        this.inspection = inspection;
    }

    public String getPrintCustomer() {
        return printCustomer;
    }

    public void setPrintCustomer(String printCustomer) {
        this.printCustomer = printCustomer;
    }

    public String getPrintConstruction() {
        return printConstruction;
    }

    public void setPrintConstruction(String printConstruction) {
        this.printConstruction = printConstruction;
    }

    public String getPrintProducts() {
        return printProducts;
    }

    public void setPrintProducts(String printProducts) {
        this.printProducts = printProducts;
    }

    public String getPrintSupplier() {
        return printSupplier;
    }

    public void setPrintSupplier(String printSupplier) {
        this.printSupplier = printSupplier;
    }

    public Date getShipDates() {
        return shipDates;
    }

    public void setShipDates(Date shipDates) {
        this.shipDates = shipDates;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getUnitdistributeId() {
        return unitdistributeId;
    }

    public void setUnitdistributeId(String unitdistributeId) {
        this.unitdistributeId = unitdistributeId;
    }

    public String getPrintShippersName() {
        return printShippersName;
    }

    public void setPrintShippersName(String printShippersName) {
        this.printShippersName = printShippersName;
    }

    public String getOldTaskId() {
        return oldTaskId;
    }

    public void setOldTaskId(String oldTaskId) {
        this.oldTaskId = oldTaskId;
    }
}
