/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.base.bases.vo.SettlementPerioddetailVO;
import com.ejianc.business.base.bases.vo.ShippersInfoApiVO;
import com.ejianc.business.base.bases.vo.ShippersfareVO;
import com.ejianc.business.production.task.api.ProductionTaskApi;
import com.ejianc.business.production.task.vo.TasktransportVO;
import com.ejianc.business.sale.bean.ManualshipmentEntity;
import com.ejianc.business.sale.bean.ProductorInfoEntity;
import com.ejianc.business.sale.bean.ProjectInfoEntity;
import com.ejianc.business.sale.bean.SalesdeliveryEntity;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.bean.SalesorderdetilsEntity;
import com.ejianc.business.sale.bean.TransportContactEntity;
import com.ejianc.business.sale.service.IManualshipmentService;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.IProjectInfoService;
import com.ejianc.business.sale.service.ISalesdeliveryService;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.ISalesorderdetilsService;
import com.ejianc.business.sale.service.ITransportContactService;
import com.ejianc.business.sale.vo.ManualshipmentVO;
import com.ejianc.business.sale.vo.SignfreightdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"manualshipment"})
public class ManualshipmentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "sale-manualshipment";
    private static final String BILL_CODES = "sale-salesorder";
    @Autowired
    private IManualshipmentService service;
    @Autowired
    private ISalesorderService salesorderService;
    @Autowired
    private ISalesdeliveryService salesdeliveryService;
    @Autowired
    private ISalesorderdetilsService salesorderdetilsService;
    @Autowired
    private IProductorInfoService productorInfoService;
    @Autowired
    private IProjectInfoService projectInfoService;
    @Autowired
    private ITransportContactService transportContactService;
    @Qualifier(value="com.ejianc.business.production.task.api.ProductionTaskApi")
    @Autowired
    private ProductionTaskApi productionTaskApi;
    @Autowired
    private SessionManager sessionManager;
    @Qualifier(value="com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    private BaseApi baseApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<ManualshipmentVO> saveOrUpdate(@RequestBody ManualshipmentVO saveOrUpdateVO) {
        CommonResponse commonResponse1;
        ManualshipmentEntity entity = (ManualshipmentEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ManualshipmentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setShipmentType(0);
                entity.setReceiptStatus(1);
                entity.setInspection("\u5408\u683c");
                entity.setShipDates(entity.getShipDate());
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getShippingMethod() == 0) {
            entity.setPrintShippersName(entity.getShippersName());
        } else {
            entity.setPrintShippersName(null);
        }
        if (entity.getShippingMethod() == 0) {
            CommonResponse commonResponse = this.baseApi.getShippersInfo(entity.getNumberPlate(), entity.getOrgId());
            if (commonResponse.getCode() == 0) {
                if (((ShippersInfoApiVO)commonResponse.getData()).getShippersfareVOS().size() > 0) {
                    BigDecimal freight = this.freightCount(entity.getDistance(), entity.getNetWeight(), ((ShippersInfoApiVO)commonResponse.getData()).getShippersfareVOS());
                    entity.setFreight(freight);
                } else {
                    entity.setFreight(new BigDecimal(0.0));
                }
            } else {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
        entity.setPaidMoney(new BigDecimal(0.0));
        entity.setOutstandingMoney(entity.getFreight());
        this.service.saveOrUpdate((Object)entity, false);
        TasktransportVO tasktransportVO = new TasktransportVO();
        tasktransportVO.setId(entity.getNumberPlateId());
        tasktransportVO.setTransportCount(entity.getNetWeight());
        tasktransportVO.setTransportTime(entity.getShipDate());
        tasktransportVO.setTransportStatue(Integer.valueOf(2));
        CommonResponse commonResponse2 = this.productionTaskApi.updateTransport(tasktransportVO);
        if (commonResponse2.getCode() != 0) {
            throw new BusinessException(commonResponse2.getMsg());
        }
        if (entity.getCarId() != null && (commonResponse1 = this.baseApi.updatestatus(entity.getCarId(), Integer.valueOf(1))).getCode() != 0) {
            throw new BusinessException(commonResponse1.getMsg());
        }
        ManualshipmentVO vo = (ManualshipmentVO)((Object)BeanMapper.map((Object)((Object)entity), ManualshipmentVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ManualshipmentVO> queryDetail(Long id) {
        ManualshipmentEntity entity = (ManualshipmentEntity)((Object)this.service.selectById(id));
        ManualshipmentVO vo = (ManualshipmentVO)((Object)BeanMapper.map((Object)((Object)entity), ManualshipmentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ManualshipmentVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ManualshipmentVO vo : vos) {
                CommonResponse commonResponse = this.productionTaskApi.updateTransportState(((ManualshipmentEntity)((Object)this.service.getById(vo.getId()))).getNumberPlateId(), Integer.valueOf(1));
                if (commonResponse.getCode() == 0) continue;
                throw new BusinessException(commonResponse.getMsg());
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ManualshipmentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("productName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        for (ManualshipmentEntity manualshipmentEntity : page.getRecords()) {
            if (manualshipmentEntity.getReceiptStatus() != 1) continue;
            manualshipmentEntity.setConfirmNumber(manualshipmentEntity.getNetWeight());
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ManualshipmentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("ship_date");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Manualshipment-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refManualshipmentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ManualshipmentVO>> refManualshipmentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ManualshipmentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/receipt"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ManualshipmentVO>> receipt(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("productName");
        param.getParams().put("receipt_status", new Parameter("eq", (Object)1));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageSize(9999999);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        for (ManualshipmentEntity manualshipmentEntity : page.getRecords()) {
            manualshipmentEntity.setConfirmNumber(manualshipmentEntity.getNetWeight());
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ManualshipmentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateFreightStatus"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<IPage<ManualshipmentVO>> updateFreightStatus(@RequestBody List<ManualshipmentVO> saveOrUpdateVO) {
        for (ManualshipmentVO manualshipmentVO : saveOrUpdateVO) {
            ManualshipmentEntity manualshipment = (ManualshipmentEntity)((Object)this.service.getById(manualshipmentVO.getId()));
            manualshipment.setFreightStatus(1);
            manualshipment.setReceiptStatus(0);
            manualshipment.setReason(manualshipmentVO.getReason());
            manualshipment.setAbstracts(manualshipmentVO.getAbstracts());
            manualshipment.setFreightTime(new Date());
            manualshipment.setConfirmNumber(manualshipmentVO.getConfirmNumber());
            manualshipment.setBillState(3);
            BigDecimal freight = new BigDecimal(0.0);
            if (manualshipment.getShippingMethod() == 0) {
                CommonResponse commonResponse = this.baseApi.getShippersInfo(manualshipment.getNumberPlate(), manualshipment.getOrgId());
                if (commonResponse.getCode() == 0) {
                    if (((ShippersInfoApiVO)commonResponse.getData()).getShippersfareVOS().size() > 0) {
                        if (manualshipmentVO.getReason() != null) {
                            freight = manualshipmentVO.getReason().equals("\u672c\u5382\u539f\u56e0") ? this.freightCount(manualshipmentVO.getDistance(), manualshipmentVO.getNetWeight(), ((ShippersInfoApiVO)commonResponse.getData()).getShippersfareVOS()) : this.freightCount(manualshipmentVO.getDistance(), manualshipmentVO.getConfirmNumber(), ((ShippersInfoApiVO)commonResponse.getData()).getShippersfareVOS());
                            manualshipment.setFreight(freight);
                        } else {
                            freight = this.freightCount(manualshipmentVO.getDistance(), manualshipmentVO.getNetWeight(), ((ShippersInfoApiVO)commonResponse.getData()).getShippersfareVOS());
                            manualshipment.setFreight(freight);
                        }
                    } else {
                        manualshipment.setFreight(new BigDecimal(0.0));
                    }
                } else {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
            this.service.updateById((Object)manualshipment);
        }
        this.saveSale(saveOrUpdateVO);
        QueryParam param = new QueryParam();
        param.getParams().put("receipt_status", new Parameter("eq", (Object)1));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        for (ManualshipmentEntity manualshipmentEntity : page.getRecords()) {
            manualshipmentEntity.setConfirmNumber(manualshipmentEntity.getNetWeight());
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ManualshipmentVO.class));
        return CommonResponse.success((String)"\u786e\u8ba4\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/freightList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SignfreightdetailVO>> freightList(@RequestBody QueryParam param) {
        SignfreightdetailVO SignfreightdetailList;
        QueryWrapper queryWrapper = new QueryWrapper();
        QueryWrapper queryWrapper1 = new QueryWrapper();
        if (((Parameter)param.getParams().get("shippers_id")).getValue() != null) {
            queryWrapper.eq((Object)"shippers_id", ((Parameter)param.getParams().get("shippers_id")).getValue());
            queryWrapper1.eq((Object)"shippers_id", ((Parameter)param.getParams().get("shippers_id")).getValue());
        }
        if (((Parameter)param.getParams().get("date")).getValue() != null) {
            String orgid = ((Parameter)param.getParams().get("orgId")).getValue().toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date d = new Date(Long.valueOf(((Parameter)param.getParams().get("date")).getValue().toString()));
            String date = sdf.format(d);
            CommonResponse commonResponse = this.baseApi.querysettlement(date, orgid);
            if (commonResponse.getCode() != 0) {
                throw new BusinessException(commonResponse.getMsg());
            }
            Date start = ((SettlementPerioddetailVO)commonResponse.getData()).getStartDate();
            Date end = ((SettlementPerioddetailVO)commonResponse.getData()).getEndDate();
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String starttime = sd.format(start);
            String endtiem = sd.format(end);
            queryWrapper.between((Object)"freight_time", (Object)starttime, (Object)endtiem);
            queryWrapper1.between((Object)"transport_date", (Object)starttime, (Object)endtiem);
        }
        queryWrapper.eq((Object)"freight_status", (Object)1);
        List list = this.service.list((Wrapper)queryWrapper);
        List transportContactEntity = this.transportContactService.list((Wrapper)queryWrapper1);
        ArrayList<SignfreightdetailVO> signfreightdetailVO = new ArrayList<SignfreightdetailVO>();
        for (ManualshipmentEntity manualshipmentEntity : list) {
            SignfreightdetailList = new SignfreightdetailVO();
            SignfreightdetailList.setId(manualshipmentEntity.getId());
            SignfreightdetailList.setBillCode(manualshipmentEntity.getBillCode());
            SignfreightdetailList.setNumberPlate(manualshipmentEntity.getNumberPlate());
            SignfreightdetailList.setConsignmentDate(manualshipmentEntity.getShipDate());
            SignfreightdetailList.setConsignmentType(manualshipmentEntity.getShipmentType());
            if (manualshipmentEntity.getReason() == null) {
                SignfreightdetailList.setConfirmNumber(manualshipmentEntity.getNetWeight());
            } else if (manualshipmentEntity.getReason().equals("\u672c\u5382\u539f\u56e0")) {
                SignfreightdetailList.setConfirmNumber(manualshipmentEntity.getNetWeight());
            } else if (manualshipmentEntity.getReason().equals("\u8fd0\u8f93\u539f\u56e0")) {
                SignfreightdetailList.setConfirmNumber(manualshipmentEntity.getConfirmNumber());
            }
            SignfreightdetailList.setDistance(manualshipmentEntity.getDistance());
            SignfreightdetailList.setFreight(manualshipmentEntity.getFreight());
            SignfreightdetailList.setManualshipmentId(manualshipmentEntity.getId());
            SignfreightdetailList.setRowState("add");
            signfreightdetailVO.add(SignfreightdetailList);
        }
        for (TransportContactEntity transportContactEntity1 : transportContactEntity) {
            SignfreightdetailList = new SignfreightdetailVO();
            SignfreightdetailList.setId(transportContactEntity1.getId());
            SignfreightdetailList.setBillCode(transportContactEntity1.getBillCode());
            SignfreightdetailList.setConsignmentDate(transportContactEntity1.getTransportDate());
            SignfreightdetailList.setConsignmentType(2);
            SignfreightdetailList.setConfirmNumber(transportContactEntity1.getShippersQuantity());
            SignfreightdetailList.setFreight(transportContactEntity1.getMoney());
            SignfreightdetailList.setManualshipmentId(transportContactEntity1.getId());
            SignfreightdetailList.setRowState("add");
            signfreightdetailVO.add(SignfreightdetailList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", signfreightdetailVO);
    }

    private BigDecimal freightCount(BigDecimal distance, BigDecimal netWeight, List<ShippersfareVO> shippersfareVO) {
        BigDecimal freight = new BigDecimal(0.0);
        if (distance.compareTo(shippersfareVO.get(0).getEndDistance()) <= 0) {
            freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
            return freight;
        }
        for (int i = 0; i < shippersfareVO.size(); ++i) {
            BigDecimal fee;
            BigDecimal distan;
            if (i == 0) {
                freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
                continue;
            }
            if (distance.compareTo(shippersfareVO.get(i).getEndDistance()) >= 0) {
                distan = shippersfareVO.get(i).getEndDistance().subtract(shippersfareVO.get(i).getStartDistance());
                fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
                freight = freight.add(fee);
                continue;
            }
            distan = distance.subtract(shippersfareVO.get(i).getStartDistance());
            fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
            freight = freight.add(fee);
            break;
        }
        return freight;
    }

    private Boolean saveSale(List<ManualshipmentVO> saveOrUpdateVO) {
        for (ManualshipmentVO manualshipmentVO : saveOrUpdateVO) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"customer_id", (Object)manualshipmentVO.getCustomerId().toString());
            queryWrapper.eq((Object)"project_id", (Object)manualshipmentVO.getProjectId());
            queryWrapper.eq((Object)"worksite_id", (Object)manualshipmentVO.getWorksiteId());
            queryWrapper.eq((Object)"sale_date", (Object)manualshipmentVO.getShipDates());
            queryWrapper.eq((Object)"salesorder_type", (Object)0);
            SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)this.salesorderService.getOne((Wrapper)queryWrapper));
            if (salesorderEntity != null) {
                SalesdeliveryEntity salesdeliveryEntity = new SalesdeliveryEntity();
                salesdeliveryEntity.setMid(salesorderEntity.getId());
                salesdeliveryEntity.setBillCode(manualshipmentVO.getBillCode());
                salesdeliveryEntity.setCustomerId(manualshipmentVO.getCustomerId());
                salesdeliveryEntity.setCustomerName(manualshipmentVO.getCustomerName());
                salesdeliveryEntity.setProjectId(manualshipmentVO.getProjectId());
                salesdeliveryEntity.setProjectName(manualshipmentVO.getProjectName());
                salesdeliveryEntity.setWorksiteId(manualshipmentVO.getWorksiteId());
                salesdeliveryEntity.setWorksiteName(manualshipmentVO.getWorksiteName());
                salesdeliveryEntity.setProductId(manualshipmentVO.getProductId());
                salesdeliveryEntity.setProductName(manualshipmentVO.getProductName());
                salesdeliveryEntity.setShipDate(manualshipmentVO.getShipDate());
                salesdeliveryEntity.setNumberPlate(manualshipmentVO.getNumberPlate());
                salesdeliveryEntity.setNetWeight(manualshipmentVO.getNetWeight());
                salesdeliveryEntity.setShippingMethod(manualshipmentVO.getShippingMethod());
                salesdeliveryEntity.setFreight(manualshipmentVO.getFreight());
                salesdeliveryEntity.setShipmentType(manualshipmentVO.getShipmentType());
                salesdeliveryEntity.setConfirmNumber(manualshipmentVO.getConfirmNumber());
                salesdeliveryEntity.setReceiptStatus(0);
                salesdeliveryEntity.setShipDates(manualshipmentVO.getShipDates());
                this.salesdeliveryService.save((Object)salesdeliveryEntity);
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.select(new String[]{"DISTINCT product_id,shipping_method"});
                queryWrapper1.eq((Object)"mid", (Object)salesorderEntity.getId());
                List salesdeliverylist = this.salesdeliveryService.list((Wrapper)queryWrapper1);
                for (SalesdeliveryEntity salesdelivery : salesdeliverylist) {
                    QueryWrapper queryWrapper2 = new QueryWrapper();
                    queryWrapper2.eq((Object)"product_info_id", (Object)salesdelivery.getProductId());
                    queryWrapper2.eq((Object)"salesorder_id", (Object)salesorderEntity.getId());
                    queryWrapper2.eq((Object)"shipping_method", (Object)salesdelivery.getShippingMethod());
                    SalesorderdetilsEntity salesorderdetilsEntity = (SalesorderdetilsEntity)((Object)this.salesorderdetilsService.getOne((Wrapper)queryWrapper2));
                    if (salesorderdetilsEntity != null) {
                        QueryWrapper queryWrapper3 = new QueryWrapper();
                        queryWrapper3.select(new String[]{"sum(confirm_number) as number"});
                        queryWrapper3.eq((Object)"mid", (Object)salesorderEntity.getId());
                        queryWrapper3.eq((Object)"product_id", (Object)salesdelivery.getProductId());
                        queryWrapper3.eq((Object)"shipping_method", (Object)salesdelivery.getShippingMethod());
                        Map map = this.salesdeliveryService.getMap((Wrapper)queryWrapper3);
                        Double number = Double.valueOf(String.valueOf(map.get("number")));
                        salesorderdetilsEntity.setSalesVolume(BigDecimal.valueOf(number));
                        salesorderdetilsEntity.setSalesAmount(salesorderdetilsEntity.getSalesVolume().multiply(salesorderdetilsEntity.getUnitPrice()));
                        salesorderdetilsEntity.setProductionQuantity(BigDecimal.valueOf(number));
                        salesorderdetilsEntity.setProductionAmount(salesorderdetilsEntity.getSalesVolume().multiply(salesorderdetilsEntity.getUnitPrice()));
                        this.salesorderdetilsService.updateById((Object)salesorderdetilsEntity);
                        continue;
                    }
                    ProductorInfoEntity productorInfoEntity = (ProductorInfoEntity)((Object)this.productorInfoService.getById(salesdelivery.getProductId()));
                    SalesorderdetilsEntity salesorderdetils = new SalesorderdetilsEntity();
                    salesorderdetils.setSalesorderId(salesorderEntity.getId());
                    salesorderdetils.setProductName(productorInfoEntity.getProductName());
                    salesorderdetils.setSpecName(productorInfoEntity.getSpecName());
                    salesorderdetils.setStoneName(productorInfoEntity.getStoneName());
                    salesorderdetils.setAsphaltName(productorInfoEntity.getAsphaltName());
                    salesorderdetils.setProductInfoId(productorInfoEntity.getId());
                    salesorderdetils.setProductId(productorInfoEntity.getProductId());
                    salesorderdetils.setShippingMethod(salesdelivery.getShippingMethod());
                    if (productorInfoEntity.getTransportMethod().equals(salesdelivery.getShippingMethod())) {
                        salesorderdetils.setUnitPrice(productorInfoEntity.getUnitPrice());
                    } else {
                        salesorderdetils.setUnitPrice(productorInfoEntity.getUnitPrice().subtract(productorInfoEntity.getFreightPoor()));
                    }
                    salesorderdetils.setVarietiesId1(productorInfoEntity.getVarietiesId1());
                    salesorderdetils.setVarietiesName1(productorInfoEntity.getVarietiesName1());
                    salesorderdetils.setCategoryId1(productorInfoEntity.getCategoryId1());
                    salesorderdetils.setCategoryName1(productorInfoEntity.getCategoryName1());
                    salesorderdetils.setThousandRate1(productorInfoEntity.getThousandRate1());
                    salesorderdetils.setVarietiesId2(productorInfoEntity.getVarietiesId2());
                    salesorderdetils.setVarietiesName2(productorInfoEntity.getVarietiesName2());
                    salesorderdetils.setCategoryId2(productorInfoEntity.getCategoryId2());
                    salesorderdetils.setCategoryName2(productorInfoEntity.getCategoryName2());
                    salesorderdetils.setThousandRate2(productorInfoEntity.getThousandRate2());
                    salesorderdetils.setVarietiesId3(productorInfoEntity.getVarietiesId3());
                    salesorderdetils.setVarietiesName3(productorInfoEntity.getVarietiesName3());
                    salesorderdetils.setCategoryId3(productorInfoEntity.getCategoryId3());
                    salesorderdetils.setCategoryName3(productorInfoEntity.getCategoryName3());
                    salesorderdetils.setThousandRate3(productorInfoEntity.getThousandRate3());
                    QueryWrapper queryWrapper3 = new QueryWrapper();
                    queryWrapper3.select(new String[]{"sum(confirm_number) as number"});
                    queryWrapper3.eq((Object)"mid", (Object)salesorderEntity.getId());
                    queryWrapper3.eq((Object)"product_id", (Object)salesdelivery.getProductId());
                    queryWrapper3.eq((Object)"shipping_method", (Object)salesdelivery.getShippingMethod());
                    Map map = this.salesdeliveryService.getMap((Wrapper)queryWrapper3);
                    Double number = Double.valueOf(String.valueOf(map.get("number")));
                    salesorderdetils.setSalesVolume(BigDecimal.valueOf(number));
                    salesorderdetils.setSalesAmount(salesorderdetils.getSalesVolume().multiply(salesorderdetils.getUnitPrice()));
                    salesorderdetils.setProductionAmount(salesorderdetils.getSalesVolume().multiply(salesorderdetils.getUnitPrice()));
                    salesorderdetils.setProductionQuantity(BigDecimal.valueOf(number));
                    this.salesorderdetilsService.save((Object)salesorderdetils);
                }
                QueryWrapper queryWrapper2 = new QueryWrapper();
                queryWrapper2.select(new String[]{"sum(sales_amount) as amount"});
                queryWrapper2.eq((Object)"salesorder_id", (Object)salesorderEntity.getId());
                Map map = this.salesorderdetilsService.getMap((Wrapper)queryWrapper2);
                Double amount = Double.valueOf(String.valueOf(map.get("amount")));
                salesorderEntity.setSalesTotalMoney(BigDecimal.valueOf(amount));
                this.salesorderService.updateById((Object)salesorderEntity);
                continue;
            }
            ProjectInfoEntity projectInfoEntity = (ProjectInfoEntity)((Object)this.projectInfoService.getById(manualshipmentVO.getProjectId()));
            SalesorderEntity salesorderEntity1 = new SalesorderEntity();
            salesorderEntity1.setProjectId(manualshipmentVO.getProjectId());
            salesorderEntity1.setProjectName(manualshipmentVO.getProjectName());
            salesorderEntity1.setCustomerId(manualshipmentVO.getCustomerId().toString());
            salesorderEntity1.setCustomerName(manualshipmentVO.getCustomerName());
            salesorderEntity1.setWorksiteId(manualshipmentVO.getWorksiteId());
            salesorderEntity1.setWorksiteName(manualshipmentVO.getWorksiteName());
            salesorderEntity1.setSaleDate(manualshipmentVO.getShipDates());
            salesorderEntity1.setSalesorderType(0);
            salesorderEntity1.setOrgId(projectInfoEntity.getOrgId());
            salesorderEntity1.setOrgName(projectInfoEntity.getOrgName());
            salesorderEntity1.setProfitcenterId(projectInfoEntity.getProfitcenterId());
            salesorderEntity1.setProfitcenterName(projectInfoEntity.getProfitcenterName());
            salesorderEntity1.setIsSign(1);
            Calendar cal = Calendar.getInstance();
            int month = cal.get(2) + 1;
            int year = cal.get(1);
            String mon = "";
            mon = month < 10 ? "0" + month : String.valueOf(month);
            salesorderEntity1.setReceivablesTime(year + "-" + mon);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODES, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)manualshipmentVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            salesorderEntity1.setBillCode((String)billCode.getData());
            this.salesorderService.save((Object)salesorderEntity1);
            SalesorderEntity salesorderEntitys = (SalesorderEntity)((Object)this.salesorderService.getOne((Wrapper)queryWrapper));
            SalesdeliveryEntity salesdeliveryEntity = new SalesdeliveryEntity();
            salesdeliveryEntity.setMid(salesorderEntitys.getId());
            salesdeliveryEntity.setBillCode(manualshipmentVO.getBillCode());
            salesdeliveryEntity.setCustomerId(manualshipmentVO.getCustomerId());
            salesdeliveryEntity.setCustomerName(manualshipmentVO.getCustomerName());
            salesdeliveryEntity.setProjectId(manualshipmentVO.getProjectId());
            salesdeliveryEntity.setProjectName(manualshipmentVO.getProjectName());
            salesdeliveryEntity.setWorksiteId(manualshipmentVO.getWorksiteId());
            salesdeliveryEntity.setWorksiteName(manualshipmentVO.getWorksiteName());
            salesdeliveryEntity.setProductId(manualshipmentVO.getProductId());
            salesdeliveryEntity.setProductName(manualshipmentVO.getProductName());
            salesdeliveryEntity.setShipDate(manualshipmentVO.getShipDate());
            salesdeliveryEntity.setNumberPlate(manualshipmentVO.getNumberPlate());
            salesdeliveryEntity.setNetWeight(manualshipmentVO.getNetWeight());
            salesdeliveryEntity.setShippingMethod(manualshipmentVO.getShippingMethod());
            salesdeliveryEntity.setFreight(manualshipmentVO.getFreight());
            salesdeliveryEntity.setShipmentType(manualshipmentVO.getShipmentType());
            salesdeliveryEntity.setConfirmNumber(manualshipmentVO.getConfirmNumber());
            salesdeliveryEntity.setReceiptStatus(0);
            salesdeliveryEntity.setShipDates(manualshipmentVO.getShipDates());
            this.salesdeliveryService.save((Object)salesdeliveryEntity);
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.select(new String[]{"DISTINCT product_id,shipping_method"});
            queryWrapper1.eq((Object)"mid", (Object)salesorderEntitys.getId());
            List salesdeliverylist = this.salesdeliveryService.list((Wrapper)queryWrapper1);
            for (SalesdeliveryEntity salesdelivery : salesdeliverylist) {
                QueryWrapper queryWrapper2 = new QueryWrapper();
                queryWrapper2.eq((Object)"product_info_id", (Object)salesdelivery.getProductId());
                queryWrapper2.eq((Object)"salesorder_id", (Object)salesorderEntitys.getId());
                queryWrapper2.eq((Object)"shipping_method", (Object)salesdelivery.getShippingMethod());
                SalesorderdetilsEntity salesorderdetilsEntity = (SalesorderdetilsEntity)((Object)this.salesorderdetilsService.getOne((Wrapper)queryWrapper2));
                if (salesorderdetilsEntity != null) {
                    QueryWrapper queryWrapper3 = new QueryWrapper();
                    queryWrapper3.select(new String[]{"sum(confirm_number) as number"});
                    queryWrapper3.eq((Object)"mid", (Object)salesorderEntitys.getId());
                    queryWrapper3.eq((Object)"product_id", (Object)salesdelivery.getProductId());
                    queryWrapper3.eq((Object)"shipping_method", (Object)salesdelivery.getShippingMethod());
                    Map map = this.salesdeliveryService.getMap((Wrapper)queryWrapper3);
                    Double number = Double.valueOf(String.valueOf(map.get("number")));
                    salesorderdetilsEntity.setSalesVolume(BigDecimal.valueOf(number));
                    salesorderdetilsEntity.setSalesAmount(salesorderdetilsEntity.getSalesVolume().add(salesorderdetilsEntity.getUnitPrice()));
                    this.salesorderdetilsService.updateById((Object)salesorderdetilsEntity);
                    continue;
                }
                ProductorInfoEntity productorInfoEntity = (ProductorInfoEntity)((Object)this.productorInfoService.getById(salesdelivery.getProductId()));
                SalesorderdetilsEntity salesorderdetils = new SalesorderdetilsEntity();
                salesorderdetils.setSalesorderId(salesorderEntitys.getId());
                salesorderdetils.setProductName(productorInfoEntity.getProductName());
                salesorderdetils.setSpecName(productorInfoEntity.getSpecName());
                salesorderdetils.setStoneName(productorInfoEntity.getStoneName());
                salesorderdetils.setAsphaltName(productorInfoEntity.getAsphaltName());
                salesorderdetils.setProductInfoId(productorInfoEntity.getId());
                salesorderdetils.setProductId(productorInfoEntity.getProductId());
                salesorderdetils.setShippingMethod(salesdelivery.getShippingMethod());
                if (productorInfoEntity.getTransportMethod().equals(salesdelivery.getShippingMethod())) {
                    salesorderdetils.setUnitPrice(productorInfoEntity.getUnitPrice());
                } else {
                    salesorderdetils.setUnitPrice(productorInfoEntity.getUnitPrice().subtract(productorInfoEntity.getFreightPoor()));
                }
                salesorderdetils.setVarietiesId1(productorInfoEntity.getVarietiesId1());
                salesorderdetils.setVarietiesName1(productorInfoEntity.getVarietiesName1());
                salesorderdetils.setCategoryId1(productorInfoEntity.getCategoryId1());
                salesorderdetils.setCategoryName1(productorInfoEntity.getCategoryName1());
                salesorderdetils.setThousandRate1(productorInfoEntity.getThousandRate1());
                salesorderdetils.setVarietiesId2(productorInfoEntity.getVarietiesId2());
                salesorderdetils.setVarietiesName2(productorInfoEntity.getVarietiesName2());
                salesorderdetils.setCategoryId2(productorInfoEntity.getCategoryId2());
                salesorderdetils.setCategoryName2(productorInfoEntity.getCategoryName2());
                salesorderdetils.setThousandRate2(productorInfoEntity.getThousandRate2());
                salesorderdetils.setVarietiesId3(productorInfoEntity.getVarietiesId3());
                salesorderdetils.setVarietiesName3(productorInfoEntity.getVarietiesName3());
                salesorderdetils.setCategoryId3(productorInfoEntity.getCategoryId3());
                salesorderdetils.setCategoryName3(productorInfoEntity.getCategoryName3());
                salesorderdetils.setThousandRate3(productorInfoEntity.getThousandRate3());
                QueryWrapper queryWrapper3 = new QueryWrapper();
                queryWrapper3.select(new String[]{"sum(confirm_number) as number"});
                queryWrapper3.eq((Object)"mid", (Object)salesorderEntitys.getId());
                queryWrapper3.eq((Object)"product_id", (Object)salesdelivery.getProductId());
                queryWrapper3.eq((Object)"shipping_method", (Object)salesdelivery.getShippingMethod());
                Map map = this.salesdeliveryService.getMap((Wrapper)queryWrapper3);
                Double number = Double.valueOf(String.valueOf(map.get("number")));
                salesorderdetils.setSalesVolume(BigDecimal.valueOf(number));
                salesorderdetils.setSalesAmount(salesorderdetils.getSalesVolume().multiply(salesorderdetils.getUnitPrice()));
                salesorderdetils.setProductionAmount(salesorderdetils.getSalesVolume().multiply(salesorderdetils.getUnitPrice()));
                salesorderdetils.setProductionQuantity(BigDecimal.valueOf(number));
                this.salesorderdetilsService.save((Object)salesorderdetils);
            }
            QueryWrapper queryWrapper2 = new QueryWrapper();
            queryWrapper2.select(new String[]{"sum(sales_amount) as amount"});
            queryWrapper2.eq((Object)"salesorder_id", (Object)salesorderEntitys.getId());
            Map map = this.salesorderdetilsService.getMap((Wrapper)queryWrapper2);
            Double amount = Double.valueOf(String.valueOf(map.get("amount")));
            salesorderEntitys.setSalesTotalMoney(BigDecimal.valueOf(amount));
            this.salesorderService.updateById((Object)salesorderEntitys);
        }
        return true;
    }
}

