/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sale.bean.ProductorInfoEntity;
import com.ejianc.business.sale.bean.ProjectInfoEntity;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.salesorder.vo.CloseVO;
import com.ejianc.business.sale.salesorder.vo.ProductInfoVO;
import com.ejianc.business.sale.salesorder.vo.WeighinginfoApiVO;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.IProjectInfoService;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.IWeighinginfoService;
import com.ejianc.business.sale.vo.SalesorderVO;
import com.ejianc.business.sale.vo.SalesorderdetilsVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sale/saleorderApi/"})
public class WeighinginfoApi {
    private static final String CODE = "sale-salesorder";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IWeighinginfoService weighinginfoService;
    @Autowired
    private IProductorInfoService productorInfoService;
    @Autowired
    private IProjectInfoService projectInfoService;
    @Autowired
    private ISalesorderService salesorderService;

    @RequestMapping(value={"/saveWeighinginfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveWeighinginfo(@RequestBody WeighinginfoApiVO WeighinginfoApiVO2) {
        CommonResponse<String> commonResponse = this.weighinginfoService.saveManualshipment(WeighinginfoApiVO2);
        return CommonResponse.success((String)"\u751f\u6210\u6210\u529f\uff01", (Object)commonResponse.getData());
    }

    @RequestMapping(value={"/getProductInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ProductInfoVO>> getProductInfo(@RequestParam String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.productorInfoService.list((Wrapper)queryWrapper);
        ArrayList<ProductInfoVO> productInfoList = new ArrayList<ProductInfoVO>();
        for (ProductorInfoEntity productorInfoEntity : list) {
            ProductInfoVO productInfoVO = new ProductInfoVO();
            productInfoVO.setProductId(productorInfoEntity.getId());
            productInfoVO.setProductName(productorInfoEntity.getProductName());
            productInfoVO.setAsphaltSpec(productorInfoEntity.getAsphaltName());
            productInfoVO.setProjectTotle(productorInfoEntity.getQuantity());
            String addCount = null;
            if (productorInfoEntity.getCategoryName1() != null) {
                addCount = productorInfoEntity.getCategoryName1();
            }
            if (productorInfoEntity.getCategoryName2() != null) {
                addCount = addCount + ";" + productorInfoEntity.getCategoryName2();
            }
            if (productorInfoEntity.getCategoryName3() != null) {
                addCount = addCount + ";" + productorInfoEntity.getCategoryName3();
            }
            if (productorInfoEntity.getTransportMethod() == 1) {
                productInfoVO.setTransportMethod("\u81ea\u8fd0");
            }
            if (productorInfoEntity.getTransportMethod() == 0) {
                productInfoVO.setTransportMethod("\u4ee3\u8fd0");
            }
            productInfoVO.setAddCount(addCount);
            productInfoVO.setVarietiesId1(productorInfoEntity.getVarietiesId1());
            productInfoVO.setVarietiesName1(productorInfoEntity.getVarietiesName1());
            productInfoVO.setCategoryId1(productorInfoEntity.getCategoryId1());
            productInfoVO.setCategoryName1(productorInfoEntity.getCategoryName1());
            productInfoVO.setThousandRate1(productorInfoEntity.getThousandRate1());
            productInfoVO.setVarietiesId2(productorInfoEntity.getVarietiesId2());
            productInfoVO.setVarietiesName2(productorInfoEntity.getVarietiesName2());
            productInfoVO.setCategoryId2(productorInfoEntity.getCategoryId2());
            productInfoVO.setCategoryName2(productorInfoEntity.getCategoryName2());
            productInfoVO.setThousandRate2(productorInfoEntity.getThousandRate2());
            productInfoVO.setVarietiesId3(productorInfoEntity.getVarietiesId3());
            productInfoVO.setVarietiesName3(productorInfoEntity.getVarietiesName3());
            productInfoVO.setCategoryId3(productorInfoEntity.getCategoryId3());
            productInfoVO.setCategoryName3(productorInfoEntity.getCategoryName3());
            productInfoVO.setThousandRate3(productorInfoEntity.getThousandRate3());
            productInfoList.add(productInfoVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", productInfoList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveSaleorder"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional
    public CommonResponse saveSaleorder(@RequestBody CloseVO closeVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)closeVO.getProjectId());
        ProjectInfoEntity projectInfoEntity = (ProjectInfoEntity)((Object)this.projectInfoService.getOne((Wrapper)queryWrapper));
        if (projectInfoEntity == null) throw new BusinessException("\u672a\u67e5\u5230" + closeVO.getProjectName() + "\u8be5\u5de5\u7a0b,\u4e0d\u5141\u8bb8\u751f\u6210\u9500\u552e\u5355!");
        SalesorderVO salesorderVO = new SalesorderVO();
        salesorderVO.setSalesorderType(0);
        salesorderVO.setProjectId(closeVO.getProjectId());
        salesorderVO.setProjectName(closeVO.getProjectName());
        salesorderVO.setCustomerId(closeVO.getCustomerManageId().toString());
        salesorderVO.setCustomerName(closeVO.getCustomerManageName());
        salesorderVO.setWorksiteId(closeVO.getWorksiteId());
        salesorderVO.setWorksiteName(closeVO.getWorksiteName());
        salesorderVO.setSaleDate(new Date());
        salesorderVO.setTaskId(closeVO.getTaskId());
        salesorderVO.setIsSign(1);
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        String mon = "";
        mon = month < 10 ? "0" + month : String.valueOf(month);
        salesorderVO.setReceivablesTime(year + "-" + mon);
        salesorderVO.setReceivablesDate(new Date());
        salesorderVO.setProfitcenterId(projectInfoEntity.getProfitcenterId());
        salesorderVO.setProfitcenterName(projectInfoEntity.getProfitcenterName());
        salesorderVO.setOrgId(projectInfoEntity.getOrgId());
        salesorderVO.setOrgName(projectInfoEntity.getOrgName());
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"id", (Object)closeVO.getProductId());
        queryWrapper1.eq((Object)"project_id", (Object)closeVO.getProjectId());
        ProductorInfoEntity productorInfoEntity = (ProductorInfoEntity)((Object)this.productorInfoService.getOne((Wrapper)queryWrapper1));
        if (productorInfoEntity == null) throw new BusinessException("\u672a\u67e5\u5230" + closeVO.getProductName() + "\u5de5\u7a0b\u4ea7\u54c1,\u4e0d\u5141\u8bb8\u751f\u6210\u9500\u552e\u5355!");
        ArrayList<SalesorderdetilsVO> list = new ArrayList<SalesorderdetilsVO>();
        SalesorderdetilsVO salesorderdetilsVO = new SalesorderdetilsVO();
        salesorderdetilsVO.setProductId(productorInfoEntity.getProductId());
        salesorderdetilsVO.setProductName(productorInfoEntity.getProductName());
        salesorderdetilsVO.setSpecName(productorInfoEntity.getSpecName());
        salesorderdetilsVO.setStoneName(productorInfoEntity.getStoneName());
        salesorderdetilsVO.setAsphaltName(productorInfoEntity.getAsphaltName());
        salesorderdetilsVO.setCategoryId1(productorInfoEntity.getCategoryId1());
        salesorderdetilsVO.setCategoryName1(productorInfoEntity.getCategoryName1());
        salesorderdetilsVO.setThousandRate1(productorInfoEntity.getThousandRate1());
        salesorderdetilsVO.setCategoryId2(productorInfoEntity.getCategoryId2());
        salesorderdetilsVO.setCategoryName2(productorInfoEntity.getCategoryName2());
        salesorderdetilsVO.setThousandRate2(productorInfoEntity.getThousandRate2());
        salesorderdetilsVO.setCategoryId3(productorInfoEntity.getCategoryId3());
        salesorderdetilsVO.setCategoryName3(productorInfoEntity.getCategoryName3());
        salesorderdetilsVO.setThousandRate3(productorInfoEntity.getThousandRate3());
        salesorderdetilsVO.setUnitPrice(productorInfoEntity.getUnitPrice());
        salesorderdetilsVO.setSalesVolume(closeVO.getThisQuantity());
        salesorderdetilsVO.setSalesAmount(productorInfoEntity.getUnitPrice().multiply(closeVO.getThisQuantity()));
        salesorderdetilsVO.setProductionQuantity(closeVO.getThisQuantity());
        salesorderdetilsVO.setProductionAmount(productorInfoEntity.getUnitPrice().multiply(closeVO.getThisQuantity()));
        salesorderdetilsVO.setRowState("add");
        list.add(salesorderdetilsVO);
        salesorderVO.setSalesorderdetilsList(list);
        salesorderVO.setSalesTotalMoney(productorInfoEntity.getUnitPrice().multiply(closeVO.getThisQuantity()));
        BillCodeParam codeParam = BillCodeParam.build((String)CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)salesorderVO);
        CommonResponse code = this.billCodeApi.generateBillCode(codeParam);
        SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)BeanMapper.map((Object)((Object)salesorderVO), SalesorderEntity.class));
        if (!code.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        salesorderEntity.setBillCode((String)code.getData());
        this.salesorderService.saveOrUpdate((Object)salesorderEntity, false);
        return CommonResponse.success((String)"\u751f\u6210\u9500\u552e\u5355\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delectSaleorder"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional
    public CommonResponse delectSaleorder(@RequestParam String taskId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)taskId);
        SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)this.salesorderService.getOne((Wrapper)queryWrapper));
        if (salesorderEntity.getIsSign().equals(0)) {
            throw new BusinessException("\u8be5\u751f\u4ea7\u4efb\u52a1\u5355\u5173\u8054\u7684\u9500\u552e\u5355\u5df2\u7ecf\u88ab\u7b7e\u8ba4\u4e0d\u5141\u8bb8\u53d6\u6d88\u8ba2\u5355!");
        }
        this.salesorderService.removeById(salesorderEntity.getId(), true);
        return CommonResponse.success((String)"\u53d6\u6d88\u8ba2\u5355\u6210\u529f");
    }
}

