/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.base.bases.vo.SettlementPerioddetailVO;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.bean.SalesorderdetilsEntity;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.ISalesorderdetilsService;
import com.ejianc.business.sale.utils.DateUtils;
import com.ejianc.business.sale.utils.ParamUtils;
import com.ejianc.business.sale.vo.InvoicedetialVO;
import com.ejianc.business.sale.vo.ReceivablesdetialVO;
import com.ejianc.business.sale.vo.SalesOrderReportVO;
import com.ejianc.business.sale.vo.SalesorderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"salesorder"})
public class SalesorderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "sale-salesorder";
    @Autowired
    private ISalesorderService service;
    @Autowired
    private ISalesorderdetilsService salesorderdetilsService;
    @Qualifier(value="com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    private BaseApi baseApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalesorderVO> saveOrUpdate(@RequestBody SalesorderVO saveOrUpdateVO) {
        SalesorderEntity entity = (SalesorderEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), SalesorderEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            Calendar cal = Calendar.getInstance();
            int month = cal.get(2) + 1;
            int year = cal.get(1);
            String mon = "";
            mon = month < 10 ? "0" + month : String.valueOf(month);
            entity.setReceivablesTime(year + "-" + mon);
            entity.setIsSign(1);
            for (SalesorderdetilsEntity salesorderdetilsEntity : entity.getSalesorderdetilsList()) {
                salesorderdetilsEntity.setId(null);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SalesorderVO vo = (SalesorderVO)((Object)BeanMapper.map((Object)((Object)entity), SalesorderVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalesorderVO> queryDetail(Long id) {
        SalesorderEntity entity = (SalesorderEntity)((Object)this.service.selectById(id));
        SalesorderVO vo = (SalesorderVO)((Object)BeanMapper.map((Object)((Object)entity), SalesorderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalesorderVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SalesorderVO salesorderVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalesorderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("worksiteName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalesorderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("saleDate");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList<SalesOrderReportVO> salesOrderReportVOS = new ArrayList<SalesOrderReportVO>();
        BigDecimal salesAmountAll = new BigDecimal("0.00");
        BigDecimal salesVolumeAll = new BigDecimal("0.00");
        String customerName = ((SalesorderEntity)((Object)list.get(0))).getCustomerName();
        for (SalesorderEntity entity : list) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"salesorder_id", (Object)entity.getId());
            List entities = this.salesorderdetilsService.list((Wrapper)query);
            for (SalesorderdetilsEntity orderdetil : entities) {
                SalesOrderReportVO VO = new SalesOrderReportVO();
                VO.setCustomerName(entity.getCustomerName());
                VO.setWorksiteName(entity.getWorksiteName());
                VO.setSaleDate(DateUtils.dateSimple(entity.getSaleDate()));
                StringBuffer productName = new StringBuffer(orderdetil.getProductName());
                if (orderdetil.getCategoryId1() != null) {
                    productName.append("+" + orderdetil.getCategoryName1());
                }
                if (orderdetil.getCategoryId2() != null) {
                    productName.append("+" + orderdetil.getCategoryName2());
                }
                if (orderdetil.getCategoryId3() != null) {
                    productName.append("+" + orderdetil.getCategoryName3());
                }
                VO.setProductName(productName.toString());
                VO.setSpecName(orderdetil.getSpecName());
                VO.setStoneName(orderdetil.getStoneName());
                salesAmountAll = salesAmountAll.add(orderdetil.getSalesAmount());
                salesVolumeAll = salesVolumeAll.add(orderdetil.getSalesVolume());
                VO.setSalesVolume(orderdetil.getSalesVolume());
                VO.setSalesAmount(orderdetil.getSalesAmount());
                VO.setUnitPrice(orderdetil.getUnitPrice());
                if (orderdetil.getShippingMethod() != null && orderdetil.getShippingMethod() == 0) {
                    VO.setShippingMethod("\u4ee3\u8fd0");
                } else if (orderdetil.getShippingMethod() != null && orderdetil.getShippingMethod() == 1) {
                    VO.setShippingMethod("\u81ea\u8fd0");
                }
                salesOrderReportVOS.add(VO);
            }
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", salesOrderReportVOS);
        beans.put("customerName", customerName);
        beans.put("OrderByString", ParamUtils.getOrderByString(param));
        beans.put("salesAmountAll", salesAmountAll);
        beans.put("salesVolumeAll", salesVolumeAll);
        ExcelExport.getInstance().export("Salesorder-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSalesorderData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalesorderVO>> refSalesorderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("customerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalesorderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalesorderVO>> list(@RequestBody QueryParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (((Parameter)param.getParams().get("customer_id")).getValue() != null) {
            queryWrapper.eq((Object)"customer_id", ((Parameter)param.getParams().get("customer_id")).getValue());
        }
        if (((Parameter)param.getParams().get("profitcenter_id")).getValue() != null) {
            queryWrapper.eq((Object)"profitcenter_id", ((Parameter)param.getParams().get("profitcenter_id")).getValue());
        }
        if (((Parameter)param.getParams().get("project_id")).getValue() != null) {
            queryWrapper.eq((Object)"project_id", ((Parameter)param.getParams().get("project_id")).getValue());
        }
        if (((Parameter)param.getParams().get("worksite_id")).getValue() != null) {
            queryWrapper.eq((Object)"worksite_id", ((Parameter)param.getParams().get("worksite_id")).getValue());
        }
        if (((Parameter)param.getParams().get("saleDate")).getValue() != null) {
            String orgid = ((Parameter)param.getParams().get("orgId")).getValue().toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date d = new Date(Long.valueOf(((Parameter)param.getParams().get("saleDate")).getValue().toString()));
            String date = sdf.format(d);
            CommonResponse commonResponse = this.baseApi.querysettlement(date, orgid);
            if (commonResponse.getCode() != 0) {
                throw new BusinessException(commonResponse.getMsg());
            }
            Date start = ((SettlementPerioddetailVO)commonResponse.getData()).getStartDate();
            Date end = ((SettlementPerioddetailVO)commonResponse.getData()).getEndDate();
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String starttime = sd.format(start);
            String endtiem = sd.format(end);
            queryWrapper.between((Object)"sale_date", (Object)starttime, (Object)endtiem);
        }
        queryWrapper.eq((Object)"is_sign", (Object)1);
        Page page = new Page();
        List list = this.service.list((Wrapper)queryWrapper);
        page.setRecords(list);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalesorderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/customerlist"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalesorderVO>> customerlist(@RequestBody QueryParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (((Parameter)param.getParams().get("customer_id")).getValue() != null) {
            queryWrapper.eq((Object)"customer_id", ((Parameter)param.getParams().get("customer_id")).getValue());
        }
        if (((Parameter)param.getParams().get("project_id")).getValue() != null) {
            queryWrapper.eq((Object)"project_id", ((Parameter)param.getParams().get("project_id")).getValue());
        }
        if (((Parameter)param.getParams().get("profitcenter_id")).getValue() != null) {
            queryWrapper.eq((Object)"profitcenter_id", ((Parameter)param.getParams().get("profitcenter_id")).getValue());
        }
        if (((Parameter)param.getParams().get("saleDate")).getValue() != null) {
            String orgid = ((Parameter)param.getParams().get("orgId")).getValue().toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date d = new Date(Long.valueOf(((Parameter)param.getParams().get("saleDate")).getValue().toString()));
            String date = sdf.format(d);
            CommonResponse commonResponse = this.baseApi.querysettlement(date, orgid);
            if (commonResponse.getCode() != 0) {
                throw new BusinessException(commonResponse.getMsg());
            }
            Date start = ((SettlementPerioddetailVO)commonResponse.getData()).getStartDate();
            Date end = ((SettlementPerioddetailVO)commonResponse.getData()).getEndDate();
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String starttime = sd.format(start);
            String endtiem = sd.format(end);
            queryWrapper.between((Object)"sale_date", (Object)starttime, (Object)endtiem);
        }
        queryWrapper.eq((Object)"is_sign", (Object)1);
        Page page = new Page();
        List list = this.service.list((Wrapper)queryWrapper);
        page.setRecords(list);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalesorderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/receivableslist"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ReceivablesdetialVO>> receivableslist(@RequestBody QueryParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (((Parameter)param.getParams().get("customer_id")).getValue() != null) {
            queryWrapper.eq((Object)"customer_id", ((Parameter)param.getParams().get("customer_id")).getValue());
        }
        if (((Parameter)param.getParams().get("chooseDate")).getValue() != null) {
            String date = ((Parameter)param.getParams().get("chooseDate")).getValue().toString();
            String starttime = date + "-01-01 00:00:00";
            String endtiem = date + "-12-31 23:59:59";
            queryWrapper.between((Object)"sign_date", (Object)starttime, (Object)endtiem);
        }
        queryWrapper.eq((Object)"is_sign", (Object)0);
        queryWrapper.ne((Object)"uncollected_moeny", (Object)new BigDecimal(0.0));
        List list = this.service.list((Wrapper)queryWrapper);
        ArrayList<ReceivablesdetialVO> receivablesdetialVOList = new ArrayList<ReceivablesdetialVO>();
        for (SalesorderEntity salesorderEntity : list) {
            ReceivablesdetialVO receivablesdetialVO = new ReceivablesdetialVO();
            receivablesdetialVO.setId(salesorderEntity.getId());
            receivablesdetialVO.setBillCode(salesorderEntity.getBillCode());
            receivablesdetialVO.setProjectId(salesorderEntity.getProjectId());
            receivablesdetialVO.setProjectName(salesorderEntity.getProjectName());
            receivablesdetialVO.setWorksiteId(salesorderEntity.getWorksiteId());
            receivablesdetialVO.setWorksiteName(salesorderEntity.getWorksiteName());
            receivablesdetialVO.setSignDate(salesorderEntity.getSignDate());
            receivablesdetialVO.setReceivableMoney(salesorderEntity.getSalesTotalMoney().subtract(salesorderEntity.getAccountAdjustmentMoeny()));
            if (salesorderEntity.getReceivedMoeny().doubleValue() != 0.0) {
                receivablesdetialVO.setOtherReceivedMoney(salesorderEntity.getReceivedMoeny());
                receivablesdetialVO.setReceivedMoney(new BigDecimal(0.0));
            } else {
                receivablesdetialVO.setReceivedMoney(salesorderEntity.getReceivedMoeny());
                receivablesdetialVO.setOtherReceivedMoney(new BigDecimal(0.0));
            }
            receivablesdetialVO.setUncollectedMoney(salesorderEntity.getUncollectedMoeny());
            receivablesdetialVO.setSaleId(salesorderEntity.getId());
            receivablesdetialVO.setRowState("add");
            receivablesdetialVOList.add(receivablesdetialVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", receivablesdetialVOList);
    }

    @RequestMapping(value={"/invoicelist"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<InvoicedetialVO>> invoicelist(@RequestBody QueryParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (((Parameter)param.getParams().get("customer_id")).getValue() != null) {
            queryWrapper.eq((Object)"customer_id", ((Parameter)param.getParams().get("customer_id")).getValue());
        }
        if (((Parameter)param.getParams().get("accountingaDate")).getValue() != null) {
            String[] strs = ((Parameter)param.getParams().get("accountingaDate")).getValue().toString().split(",");
            String starttime = strs[0].toString();
            String endtiem = strs[1].toString();
            queryWrapper.between((Object)"sign_date", (Object)starttime, (Object)endtiem);
        }
        queryWrapper.eq((Object)"is_sign", (Object)0);
        queryWrapper.ne((Object)"not_invoice_moeny", (Object)new BigDecimal(0.0));
        List list = this.service.list((Wrapper)queryWrapper);
        ArrayList<InvoicedetialVO> invoicedetialVOVOList = new ArrayList<InvoicedetialVO>();
        for (SalesorderEntity salesorderEntity : list) {
            InvoicedetialVO invoicedetialVO = new InvoicedetialVO();
            invoicedetialVO.setId(salesorderEntity.getId());
            invoicedetialVO.setBillCode(salesorderEntity.getBillCode());
            invoicedetialVO.setProjectId(salesorderEntity.getProjectId());
            invoicedetialVO.setProjectName(salesorderEntity.getProjectName());
            invoicedetialVO.setWorksiteId(salesorderEntity.getWorksiteId());
            invoicedetialVO.setWorksiteName(salesorderEntity.getWorksiteName());
            invoicedetialVO.setReceivablesDate(salesorderEntity.getReceivablesDate());
            invoicedetialVO.setReceivablesTime(salesorderEntity.getReceivablesTime());
            invoicedetialVO.setInvoiceMoney(salesorderEntity.getSalesTotalMoney().subtract(salesorderEntity.getAccountAdjustmentMoeny()));
            if (salesorderEntity.getInvoiceMoeny().doubleValue() != 0.0) {
                invoicedetialVO.setOtherReceivedMoney(salesorderEntity.getInvoiceMoeny());
                invoicedetialVO.setReceivedMoney(new BigDecimal(0.0));
            } else {
                invoicedetialVO.setReceivedMoney(salesorderEntity.getInvoiceMoeny());
                invoicedetialVO.setOtherReceivedMoney(new BigDecimal(0.0));
            }
            invoicedetialVO.setUncollectedMoney(salesorderEntity.getNotInvoiceMoeny());
            invoicedetialVO.setSaleId(salesorderEntity.getId());
            invoicedetialVO.setRowState("add");
            invoicedetialVOVOList.add(invoicedetialVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", invoicedetialVOVOList);
    }
}

