package com.ejianc.business.sale.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.sale.bean.ReceivablesdetialEntity;
/**
 * 收款管理
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sale_receivables")
public class ReceivablesEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="customer_id")
    private Long customerId; // 客户主键
    @TableField(value="customer_name")
    private String customerName; // 客户名称
    @TableField(value="profitcenter_id")
    private Long profitcenterId; // 利润中心id
    @TableField(value="profitcenter_name")
    private String profitcenterName; // 利润中心名称
    @TableField(value="payer")
    private String payer; // 付款人
    @TableField(value="bank_id")
    private Long bankId; // 银行主键
    @TableField(value="bank_name")
    private String bankName; // 银行名称
    @TableField(value="bank_code")
    private String bankCode; // 银行账号
    @TableField(value="receivables_money")
    private BigDecimal receivablesMoney; // 收款金额
    @TableField(value="not_distribution_money")
    private BigDecimal notDistributionMoney; // 未分配金额
    @TableField(value="receivables_type")
    private Long receivablesType; // 收款类型id
    @TableField(value="receivables_name")
    private String receivablesName; // 收款类型名称
    @TableField(value="receipt_code")
    private String receiptCode; // 收据号
    @TableField(value="checkout_time")
    private Date checkoutTime; // 结账年月日
    @TableField(value="receivables_status")
    private Integer receivablesStatus; // 收款方式 0-正常收款  1-预收款
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="abstracts")
    private String abstracts; // 摘要
    @TableField(value="balance")
    private BigDecimal balance; // 历史余额
    @TableField(value="sale_id",exist = false)
    private Long saleId; // 销售单id


    
    
    @TableField(exist=false)
    @SubEntity(serviceName="receivablesdetialService",pidName = "mid")
    private List<ReceivablesdetialEntity> receivablesdetialList = new ArrayList<>(); // 收款管理子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getProfitcenterId() {
        return profitcenterId;
    }

    public void setProfitcenterId(Long profitcenterId) {
        this.profitcenterId = profitcenterId;
    }
    public String getProfitcenterName() {
        return profitcenterName;
    }

    public void setProfitcenterName(String profitcenterName) {
        this.profitcenterName = profitcenterName;
    }
    public String getPayer() {
        return payer;
    }

    public void setPayer(String payer) {
        this.payer = payer;
    }
    public Long getBankId() {
        return bankId;
    }

    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public BigDecimal getReceivablesMoney() {
        return receivablesMoney;
    }

    public void setReceivablesMoney(BigDecimal receivablesMoney) {
        this.receivablesMoney = receivablesMoney;
    }
    public BigDecimal getNotDistributionMoney() {
        return notDistributionMoney;
    }

    public void setNotDistributionMoney(BigDecimal notDistributionMoney) {
        this.notDistributionMoney = notDistributionMoney;
    }
    public Long getReceivablesType() {
        return receivablesType;
    }

    public void setReceivablesType(Long receivablesType) {
        this.receivablesType = receivablesType;
    }
    public String getReceivablesName() {
        return receivablesName;
    }

    public void setReceivablesName(String receivablesName) {
        this.receivablesName = receivablesName;
    }
    public String getReceiptCode() {
        return receiptCode;
    }

    public void setReceiptCode(String receiptCode) {
        this.receiptCode = receiptCode;
    }
    public Date getCheckoutTime() {
        return checkoutTime;
    }

    public void setCheckoutTime(Date checkoutTime) {
        this.checkoutTime = checkoutTime;
    }
    public Integer getReceivablesStatus() {
        return receivablesStatus;
    }

    public void setReceivablesStatus(Integer receivablesStatus) {
        this.receivablesStatus = receivablesStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    

    public List<ReceivablesdetialEntity> getReceivablesdetialList() {
        return receivablesdetialList;
    }

    public void setReceivablesdetialList(List<ReceivablesdetialEntity> receivablesdetialList) {
        this.receivablesdetialList = receivablesdetialList;
    }

    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public Long getSaleId() {
        return saleId;
    }

    public void setSaleId(Long saleId) {
        this.saleId = saleId;
    }
}
