package com.ejianc.business.sale.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.service.ITatibenService;
import com.ejianc.business.sale.utils.DateUtils;
import com.ejianc.business.sale.vo.TatibenVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 他场替本厂发货
 *
 * @author biying
 */
@Controller
@RequestMapping("tatiben")
public class TatibenController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITatibenService service;

    @Autowired
    private IOrgApi iOrgApi;

//    /**
//     * @Description queryList 查询列表
//     * @param param
//     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
//     */
//    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
//
//        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//
//        List<TatibenVo> list = tatibenService.queryList(param);
//        JSONObject jsonObject = new JSONObject();
//        jsonObject.put("records", list);
//        return CommonResponse.success("查询列表数据成功！", jsonObject);
//
//    }

//
@RequestMapping(value = "/queryList", method = RequestMethod.POST)
@ResponseBody
    public CommonResponse<IPage<TatibenVo>> queryReportList(@RequestBody QueryParam param) {
        List<TatibenVo> vo = new ArrayList<>();
        List<TatibenVo> tatibenVoIPage = service.selectAll();
                for (TatibenVo tatibenVo : tatibenVoIPage){
                    tatibenVo.setId(IdWorker.getId());
                    tatibenVo.setSalesorderId(tatibenVo.getSalesorderId());
                    tatibenVo.setSaleDate(tatibenVo.getSaleDate());
                    tatibenVo.setFoundryName(tatibenVo.getFoundryName());
                    tatibenVo.setCustomerName(tatibenVo.getCustomerName());
                    tatibenVo.setProjectName(tatibenVo.getProjectName());
                    tatibenVo.setWorksiteName(tatibenVo.getWorksiteName());
                    tatibenVo.setProfitcenterName(tatibenVo.getProfitcenterName());
                    tatibenVo.setProductName(tatibenVo.getProductName());
                    tatibenVo.setUnitPrice(tatibenVo.getUnitPrice());
                    tatibenVo.setSalesVolume(tatibenVo.getSalesVolume());
                    tatibenVo.setSalesAmount(tatibenVo.getSalesAmount());
                    tatibenVo.setOwnerName(tatibenVo.getOwnerName());
                    vo.add(tatibenVo);
                }
//        return CommonResponse.success("查询列表数据成功！", tatibenVoIPage);

        IPage<TatibenVo> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), tatibenVoIPage.size());
        pageData.setRecords(tatibenVoIPage);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


//
//    @RequestMapping(value = "/queryReportList", method = RequestMethod.GET)
//    @ResponseBody
//    public IPage<TatibenVo> selectEsList(QueryParam param, Date saleDate, Long projectId, Long foundry, Long customerId, Long worksiteId, Long profitcenterId) {
////    public IPage<TatibenVo> selectEsList(QueryParam param) {
////        IPage<TatibenVo> page = service.queryPage(param,false);
//        IPage<TatibenVo> tatibenVoIPage = service.queryReportList(param,saleDate,projectId,foundry,customerId,worksiteId,profitcenterId);
////        IPage<TatibenVo> tatibenVoIPage = service.getSelect(param);
//
//        return tatibenVoIPage;
//
//    }



//    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<IPage<TatibenVo>> getList(@RequestBody QueryParam param) {
//
//        IPage<TatibenVo> page = service.getSelect(param);
//        IPage<TatibenVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TatibenVo.class));
//
//        return CommonResponse.success("查询列表数据成功！",pageData);
//    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("saleDate");
        fuzzyFields.add("creatTime");
        fuzzyFields.add("foundryName");
        fuzzyFields.add("ownerName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("productName");
        fuzzyFields.add("salesVolume");
        fuzzyFields.add("unitPrice");
        fuzzyFields.add("salesAmount");
        fuzzyFields.add("profitcenterName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        List<BentitaVo> list = service.queryList(param);
//        List<BentitaVo> salesOrderReportVOS=new ArrayList<>();
        //销售金额合计
        BigDecimal salesAmountAll = new BigDecimal("0.00");
        //销售数量合计
        BigDecimal salesVolumeAll = new BigDecimal("0.00");
//        String customerNames=list.get(0).getCustomerNames();
        List<TatibenVo> vo = new ArrayList<>();
        List<TatibenVo> tatibenVoIPage = service.selectAll();
        for (TatibenVo tatibenVo : tatibenVoIPage){
            tatibenVo.setId(IdWorker.getId());
            tatibenVo.setSalesorderId(tatibenVo.getSalesorderId());
//            tatibenVo.setSaleDate(tatibenVo.getSaleDate());
            tatibenVo.setCreatTime(DateUtils.dateSimple(tatibenVo.getSaleDate()));
            tatibenVo.setFoundryName(tatibenVo.getFoundryName());
            tatibenVo.setCustomerName(tatibenVo.getCustomerName());
            tatibenVo.setProjectName(tatibenVo.getProjectName());
            tatibenVo.setWorksiteName(tatibenVo.getWorksiteName());
            tatibenVo.setProfitcenterName(tatibenVo.getProfitcenterName());
            tatibenVo.setProductName(tatibenVo.getProductName());
            tatibenVo.setUnitPrice(tatibenVo.getUnitPrice());
            tatibenVo.setSalesVolume(tatibenVo.getSalesVolume());
            tatibenVo.setSalesAmount(tatibenVo.getSalesAmount());
            tatibenVo.setOwnerName(tatibenVo.getOwnerName());
            if (tatibenVo.getSalesAmount() != null) {
                salesAmountAll = salesAmountAll.add(tatibenVo.getSalesAmount());
            }
            if (tatibenVo.getSalesVolume() != null){
                salesVolumeAll=salesVolumeAll.add(tatibenVo.getSalesVolume());
            }
            vo.add(tatibenVo);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vo);
        beans.put("salesAmountAll", salesAmountAll);
        beans.put("salesVolumeAll", salesVolumeAll);
        ExcelExport.getInstance().export("Tatiben-export.xlsx", beans, response);
    }
}
