package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.bean.InvoiceEntity;
import com.ejianc.business.sale.mapper.ProjectInfoMapper;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sale.mapper.SignfreightMapper;
import com.ejianc.business.sale.bean.SignfreightEntity;
import com.ejianc.business.sale.service.ISignfreightService;

/**
 * 运费签认单
 * 
 * @author generator
 * 
 */
@Service("signfreightService")
public class SignfreightServiceImpl extends BaseServiceImpl<SignfreightMapper, SignfreightEntity> implements ISignfreightService{

    @Autowired
    private ProjectInfoMapper projectInfoMapper;

    @Override
    public IPage<SignfreightEntity> getSignfreight(QueryParam param) {
        IPage<SignfreightEntity> page = new Page<>();
        page.setSize(param.getPageSize());
        page.setCurrent(param.getPageIndex());
        IPage<SignfreightEntity> page1 = this.projectInfoMapper.getSignfreight(page, new QueryWrapper<SignfreightEntity>()
                .eq("tenant_id",param.getParams().get("tenantId").getValue())
                .eq("dr","0")
                .eq("manualshipment_id",param.getParams().get("manualshipmentId").getValue())
                .orderByDesc("create_time"));
        return page1;
    }
}
