package com.ejianc.business.sale.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.sale.bean.SalesorderdetilsEntity;
/**
 * 销售单信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sale_salesorder")
public class SalesorderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 工程主键
    @TableField(value="project_name")
    private String projectName; // 工程名称
    @TableField(value="customer_id")
    private String customerId; // 客户id
    @TableField(value="customer_name")
    private String customerName; // 客户名称
    @TableField(value="worksite_id")
    private Long worksiteId; // 工地主键
    @TableField(value="worksite_name")
    private String worksiteName; // 工地名称
    @TableField(value="sale_date")
    private Date saleDate; // 销售日期
    @TableField(value="remake")
    private String remake; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="profitcenter_id")
    private Long profitcenterId; // 利润中心id
    @TableField(value="profitcenter_name")
    private String profitcenterName; // 利润中心名称
    @TableField(value="sales_total_money")
    private BigDecimal salesTotalMoney; // 销售总金额
    @TableField(value="is_Sign")
    private Integer isSign; // 是否签认: 0-是,1-否,2-签认中
    @TableField(value="is_refund")
    private Integer isRefund; // 是否退款: 0是1否
    @TableField(value="is_distribution")
    private Integer isDistribution; // 是否分配: 0是1否
    @TableField(value="is_receivables")
    private Integer isReceivables; // 是否收款: 0是1否
    @TableField(value="received_moeny")
    private BigDecimal receivedMoeny; // 已收金额
    @TableField(value="uncollected_moeny")
    private BigDecimal uncollectedMoeny; // 未收金额
    @TableField(value="account_adjustment_moeny")
    private BigDecimal accountAdjustmentMoeny; // 调账金额
    @TableField(value="distribution_moeny")
    private BigDecimal distributionMoeny; // 分配金额
    @TableField(value="sign_id")
    private Long signId; // 签认单id
    @TableField(value="sign_date")
    private Date signDate; // 签认日期
    @TableField(value="receivables_date")
    private Date receivablesDate; // 收款日期
    @TableField(value="receivables_time")
    private String receivablesTime; // 收款日期汇总
    @TableField(value="salesreconciliation_id")
    private Long salesreconciliationId; // 销售调账单id
    @TableField(value="invoice_moeny")
    private BigDecimal invoiceMoeny; // 发票已开金额
    @TableField(value="not_invoice_moeny")
    private BigDecimal notInvoiceMoeny; // 发票未开金额
    @TableField(value="is_invoice")
    private Integer isInvoice; // 是否已开发票: 0是1否
    @TableField(value="salesorder_type")
    private Integer salesorderType; // 销售类型 0-自动销售单  1-手动销售单 2-销售调账生成
    @TableField(value="task_id")
    private Long taskId; // 生产任务单id
    @TableField(value="foundry")
    private Long foundry; // 替本厂发货的厂
    @TableField(value="foundry_name")
    private String foundryName; // 替本厂发货的厂名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="salesorderdetilsService",pidName = "salesorderId")//此处有pid="xxx"，默认值pid="pid"
    private List<SalesorderdetilsEntity> salesorderdetilsList = new ArrayList<>(); // 销售单子表信息
    @TableField(exist=false)
    @SubEntity(serviceName="salesdeliveryService",pidName = "mid")//此处有pid="xxx"，默认值pid="pid"
    private List<SalesdeliveryEntity> salesdeliveryList = new ArrayList<>(); // 销售发货子表信息
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getWorksiteId() {
        return worksiteId;
    }

    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }
    public Date getSaleDate() {
        return saleDate;
    }

    public void setSaleDate(Date saleDate) {
        this.saleDate = saleDate;
    }
    public String getRemake() {
        return remake;
    }

    public void setRemake(String remake) {
        this.remake = remake;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProfitcenterId() {
        return profitcenterId;
    }

    public void setProfitcenterId(Long profitcenterId) {
        this.profitcenterId = profitcenterId;
    }
    public String getProfitcenterName() {
        return profitcenterName;
    }

    public void setProfitcenterName(String profitcenterName) {
        this.profitcenterName = profitcenterName;
    }
    public BigDecimal getSalesTotalMoney() {
        return salesTotalMoney;
    }

    public void setSalesTotalMoney(BigDecimal salesTotalMoney) {
        this.salesTotalMoney = salesTotalMoney;
    }
    
    public List<SalesorderdetilsEntity> getSalesorderdetilsList() {
        return salesorderdetilsList;
    }

    public void setSalesorderdetilsList(List<SalesorderdetilsEntity> salesorderdetilsList) {
        this.salesorderdetilsList = salesorderdetilsList;
    }

    public Integer getIsSign() {
        return isSign;
    }

    public void setIsSign(Integer isSign) {
        this.isSign = isSign;
    }

    public Integer getIsRefund() {
        return isRefund;
    }

    public void setIsRefund(Integer isRefund) {
        this.isRefund = isRefund;
    }

    public Integer getIsDistribution() {
        return isDistribution;
    }

    public void setIsDistribution(Integer isDistribution) {
        this.isDistribution = isDistribution;
    }

    public BigDecimal getReceivedMoeny() {
        return receivedMoeny;
    }

    public void setReceivedMoeny(BigDecimal receivedMoeny) {
        this.receivedMoeny = receivedMoeny;
    }

    public BigDecimal getUncollectedMoeny() {
        return uncollectedMoeny;
    }

    public void setUncollectedMoeny(BigDecimal uncollectedMoeny) {
        this.uncollectedMoeny = uncollectedMoeny;
    }

    public BigDecimal getAccountAdjustmentMoeny() {
        return accountAdjustmentMoeny;
    }

    public void setAccountAdjustmentMoeny(BigDecimal accountAdjustmentMoeny) {
        this.accountAdjustmentMoeny = accountAdjustmentMoeny;
    }

    public BigDecimal getDistributionMoeny() {
        return distributionMoeny;
    }

    public void setDistributionMoeny(BigDecimal distributionMoeny) {
        this.distributionMoeny = distributionMoeny;
    }

    public Long getSignId() {
        return signId;
    }

    public void setSignId(Long signId) {
        this.signId = signId;
    }

    public Long getSalesreconciliationId() {
        return salesreconciliationId;
    }

    public void setSalesreconciliationId(Long salesreconciliationId) {
        this.salesreconciliationId = salesreconciliationId;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getReceivablesDate() {
        return receivablesDate;
    }

    public void setReceivablesDate(Date receivablesDate) {
        this.receivablesDate = receivablesDate;
    }

    public Integer getIsReceivables() {
        return isReceivables;
    }

    public void setIsReceivables(Integer isReceivables) {
        this.isReceivables = isReceivables;
    }

    public BigDecimal getInvoiceMoeny() {
        return invoiceMoeny;
    }

    public void setInvoiceMoeny(BigDecimal invoiceMoeny) {
        this.invoiceMoeny = invoiceMoeny;
    }

    public BigDecimal getNotInvoiceMoeny() {
        return notInvoiceMoeny;
    }

    public void setNotInvoiceMoeny(BigDecimal notInvoiceMoeny) {
        this.notInvoiceMoeny = notInvoiceMoeny;
    }

    public Integer getIsInvoice() {
        return isInvoice;
    }

    public void setIsInvoice(Integer isInvoice) {
        this.isInvoice = isInvoice;
    }

    public Integer getSalesorderType() {
        return salesorderType;
    }

    public void setSalesorderType(Integer salesorderType) {
        this.salesorderType = salesorderType;
    }

    public String getReceivablesTime() {
        return receivablesTime;
    }

    public void setReceivablesTime(String receivablesTime) {
        this.receivablesTime = receivablesTime;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public List<SalesdeliveryEntity> getSalesdeliveryList() {
        return salesdeliveryList;
    }

    public void setSalesdeliveryList(List<SalesdeliveryEntity> salesdeliveryList) {
        this.salesdeliveryList = salesdeliveryList;
    }

    public Long getFoundry() {
        return foundry;
    }

    public void setFoundry(Long foundry) {
        this.foundry = foundry;
    }

    public String getFoundryName() {
        return foundryName;
    }

    public void setFoundryName(String foundryName) {
        this.foundryName = foundryName;
    }
}
