package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 发票管理子表
 * 
 * @author generator
 * 
 */
public class InvoicedetialVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long mid; // 
    private String billCode; // 销售单编号
    private Long projectId; // 工程主键
    private String projectName; // 工程名称
    private Long worksiteId; // 工地主键
    private String worksiteName; // 工地名称
    private Date receivablesDate; // 记账日期
    private String receivablesTime; // 记账日期汇总
    private BigDecimal invoiceMoney; // 应开金额
    private BigDecimal receivedMoney; // 本单已开金额
    private BigDecimal otherReceivedMoney; // 其他单已开金额
    private BigDecimal uncollectedMoney; // 未收金额
    private BigDecimal distributionMoney; // 分配金额
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long saleId; // 销售单id
    

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="ProjectInfoRef")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="ConstructionsiteRef")
    public Long getWorksiteId() {
        return worksiteId;
    }

    @ReferDeserialTransfer
    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }
    public Date getReceivablesDate() {
        return receivablesDate;
    }

    public void setReceivablesDate(Date receivablesDate) {
        this.receivablesDate = receivablesDate;
    }
    public BigDecimal getInvoiceMoney() {
        return invoiceMoney;
    }

    public void setInvoiceMoney(BigDecimal invoiceMoney) {
        this.invoiceMoney = invoiceMoney;
    }
    public BigDecimal getReceivedMoney() {
        return receivedMoney;
    }

    public void setReceivedMoney(BigDecimal receivedMoney) {
        this.receivedMoney = receivedMoney;
    }
    public BigDecimal getOtherReceivedMoney() {
        return otherReceivedMoney;
    }

    public void setOtherReceivedMoney(BigDecimal otherReceivedMoney) {
        this.otherReceivedMoney = otherReceivedMoney;
    }
    public BigDecimal getUncollectedMoney() {
        return uncollectedMoney;
    }

    public void setUncollectedMoney(BigDecimal uncollectedMoney) {
        this.uncollectedMoney = uncollectedMoney;
    }
    public BigDecimal getDistributionMoney() {
        return distributionMoney;
    }

    public void setDistributionMoney(BigDecimal distributionMoney) {
        this.distributionMoney = distributionMoney;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getSaleId() {
        return saleId;
    }

    public void setSaleId(Long saleId) {
        this.saleId = saleId;
    }

    public String getReceivablesTime() {
        return receivablesTime;
    }

    public void setReceivablesTime(String receivablesTime) {
        this.receivablesTime = receivablesTime;
    }
}
