package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工程管理
 * 
 * @author generator
 * 
 */
public class ProjectInfoVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private String name; // 工程名称
    private Long customerId; // 客户id
    private String customerCode; // 客户编码
    private String customerName; // 客户名称
    private Long ownerId; // 业主id
    private String ownerName; // 业主名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectStartTime; // 工期开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectEndTime; // 工期结束时间
    private BigDecimal advanceCharge; // 预付款
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementTime; // 结清时间
    private Long customerLinkerId; // 客户联系人id
    private String customerLinkeName; // 客户联系人名称
    private String customerLinkeMobile; // 客户联系人电话
    private String customerQualityDemand; // 客户质量需求
    private String otherMatters; // 其他事项
    private Integer isLaboratoryExamine; // 是否需要实验室审核:1 是 0 否
    private Long regionId; // 区域id
    private String regionName; // 区域名称
    private String printCustomerName; // 打印客户名称
    private String printSupplyName; // 打印供应商名称
    private BigDecimal amountTotal; // 合同金额
    private Long contractId; // 合同id
    private String contractCode; // 合同编码
    private String projectType; // 工程类型
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date turnFormalDate; // 转正式工程日期
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private Long profitcenterId; // 利润中心id
    private String profitcenterName; // 利润中心名称
    private String collectionStatus; // 收款情况
    private BigDecimal controlAmount; // 控制金额
    private Integer iscontrol; // 是否应用控制额度
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private Integer isRelated; // 是否关联合同
    
    private List<ProductorInfoVO> productorInfoList = new ArrayList<>(); // 工程产品信息

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @ReferSerialTransfer(referCode="CustomermanageRef")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    @ReferSerialTransfer(referCode="OwnerRef")
    public Long getOwnerId() {
        return ownerId;
    }

    @ReferDeserialTransfer
    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }
    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }
    public Date getProjectStartTime() {
        return projectStartTime;
    }

    public void setProjectStartTime(Date projectStartTime) {
        this.projectStartTime = projectStartTime;
    }
    public Date getProjectEndTime() {
        return projectEndTime;
    }

    public void setProjectEndTime(Date projectEndTime) {
        this.projectEndTime = projectEndTime;
    }
    public BigDecimal getAdvanceCharge() {
        return advanceCharge;
    }

    public void setAdvanceCharge(BigDecimal advanceCharge) {
        this.advanceCharge = advanceCharge;
    }
    public Date getSettlementTime() {
        return settlementTime;
    }

    public void setSettlementTime(Date settlementTime) {
        this.settlementTime = settlementTime;
    }
    @ReferSerialTransfer(referCode="CustomercontactsRef")
    public Long getCustomerLinkerId() {
        return customerLinkerId;
    }

    @ReferDeserialTransfer
    public void setCustomerLinkerId(Long customerLinkerId) {
        this.customerLinkerId = customerLinkerId;
    }
    public String getCustomerLinkeName() {
        return customerLinkeName;
    }

    public void setCustomerLinkeName(String customerLinkeName) {
        this.customerLinkeName = customerLinkeName;
    }
    public String getCustomerLinkeMobile() {
        return customerLinkeMobile;
    }

    public void setCustomerLinkeMobile(String customerLinkeMobile) {
        this.customerLinkeMobile = customerLinkeMobile;
    }
    public String getCustomerQualityDemand() {
        return customerQualityDemand;
    }

    public void setCustomerQualityDemand(String customerQualityDemand) {
        this.customerQualityDemand = customerQualityDemand;
    }
    public String getOtherMatters() {
        return otherMatters;
    }

    public void setOtherMatters(String otherMatters) {
        this.otherMatters = otherMatters;
    }
    public Integer getIsLaboratoryExamine() {
        return isLaboratoryExamine;
    }

    public void setIsLaboratoryExamine(Integer isLaboratoryExamine) {
        this.isLaboratoryExamine = isLaboratoryExamine;
    }
    @ReferSerialTransfer(referCode="RegionRef")
    public Long getRegionId() {
        return regionId;
    }

    @ReferDeserialTransfer
    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }
    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }
    public String getPrintCustomerName() {
        return printCustomerName;
    }

    public void setPrintCustomerName(String printCustomerName) {
        this.printCustomerName = printCustomerName;
    }
    public String getPrintSupplyName() {
        return printSupplyName;
    }

    public void setPrintSupplyName(String printSupplyName) {
        this.printSupplyName = printSupplyName;
    }
    public BigDecimal getAmountTotal() {
        return amountTotal;
    }

    public void setAmountTotal(BigDecimal amountTotal) {
        this.amountTotal = amountTotal;
    }
    @ReferSerialTransfer(referCode="ContractRef")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public Date getTurnFormalDate() {
        return turnFormalDate;
    }

    public void setTurnFormalDate(Date turnFormalDate) {
        this.turnFormalDate = turnFormalDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getProfitcenterId() {
        return profitcenterId;
    }

    @ReferDeserialTransfer
    public void setProfitcenterId(Long profitcenterId) {
        this.profitcenterId = profitcenterId;
    }
    public String getProfitcenterName() {
        return profitcenterName;
    }

    public void setProfitcenterName(String profitcenterName) {
        this.profitcenterName = profitcenterName;
    }
    public String getCollectionStatus() {
        return collectionStatus;
    }

    public void setCollectionStatus(String collectionStatus) {
        this.collectionStatus = collectionStatus;
    }
    public BigDecimal getControlAmount() {
        return controlAmount;
    }

    public void setControlAmount(BigDecimal controlAmount) {
        this.controlAmount = controlAmount;
    }
    public Integer getIscontrol() {
        return iscontrol;
    }

    public void setIscontrol(Integer iscontrol) {
        this.iscontrol = iscontrol;
    }
    
     public List<ProductorInfoVO> getProductorInfoList() {
        return productorInfoList;
     }

     public void setProductorInfoList(List<ProductorInfoVO> productorInfoList) {
        this.productorInfoList = productorInfoList;
     }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getIsRelated() {
        return isRelated;
    }

    public void setIsRelated(Integer isRelated) {
        this.isRelated = isRelated;
    }
}
