/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.mapper.SceneCheckDetailMapper;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sceneCheckDetailService")
public class SceneCheckDetailServiceImpl
extends BaseServiceImpl<SceneCheckDetailMapper, SceneCheckDetailEntity>
implements ISceneCheckDetailService {
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;

    @Override
    public void checkDetailSubmitHandler(Long billId) {
        if (billId != null) {
            SceneCheckDetailEntity sceneCheckDetail = (SceneCheckDetailEntity)((Object)this.selectById(billId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(SceneCheckDetailEntity::getReformNumber, (Object)(sceneCheckDetail.getReformNumber() + 1));
            updateWrapper.set(SceneCheckDetailEntity::getIsReform, (Object)CheckItemReformState.REVIEW_REFORM_STATE.getCode());
            Date finishDate = sceneCheckDetail.getFinishDate();
            Date nowDate = new Date();
            if (finishDate.compareTo(nowDate) < 0) {
                updateWrapper.set(SceneCheckDetailEntity::getIsOverdue, (Object)1);
            }
            this.update((Wrapper)updateWrapper);
            SceneCheckRecordEntity sceneCheckRecord = new SceneCheckRecordEntity();
            sceneCheckRecord.setPid(sceneCheckDetail.getId());
            sceneCheckRecord.setCheckId(sceneCheckDetail.getPid());
            sceneCheckRecord.setOperationType(2);
            sceneCheckRecord.setReviewPerson(sceneCheckDetail.getReviewPerson());
            sceneCheckRecord.setReviewDescribe(sceneCheckDetail.getReviewDescribe());
            sceneCheckRecord.setReviewResult(sceneCheckDetail.getReviewResult());
            sceneCheckRecord.setImgIds(sceneCheckDetail.getReformImgIds());
            sceneCheckRecord.setCheckPerson(sceneCheckDetail.getCheckPerson());
            sceneCheckRecord.setCheckItem(sceneCheckDetail.getCheckItem());
            sceneCheckRecord.setRectificationPerson(sceneCheckDetail.getRectificationPerson());
            sceneCheckRecord.setRectificationDescribe(sceneCheckDetail.getReformMsg());
            this.sceneCheckRecordService.save((Object)sceneCheckRecord);
            int count = 0;
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter("eq", (Object)sceneCheckDetail.getPid()));
            List detailList = this.queryList(param);
            for (SceneCheckDetailEntity detailEntity : detailList) {
                if (detailEntity.getIsReform() == 1) continue;
                ++count;
            }
            if (count == 0) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)sceneCheckDetail.getPid());
                wrapper.set(SceneCheckEntity::getReformStatus, (Object)ReformState.REVIEW_STATE.getCode());
                this.service.update((Wrapper)wrapper);
            }
        }
    }
}

