package com.ejianc.business.scene.controller;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;



@RestController
@RequestMapping(value = "/overdueWarn/")
public class OverdueWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISceneCheckService service;


    @PostMapping(value = "overdue")
    public CommonResponse<String> overdue(@RequestBody JSONObject jsonParam) {
        logger.info("接收到现场管理Task参数：{}", jsonParam);
        //修改逾期状态和检查结果状态描述
        service.updateSceneCheckOverdue();
        //修改逾期数量
        service.updateSceneCheckOverdueNumber();
        return CommonResponse.success("更新成功！");
    }
}
