/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.mapper.SceneCheckMapper;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.NoticeEnum;
import com.ejianc.business.scene.util.OperationState;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.util.SubmitState;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.business.scene.vo.XcjcsssjhzVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="sceneCheckService")
public class SceneCheckServiceImpl
extends BaseServiceImpl<SceneCheckMapper, SceneCheckEntity>
implements ISceneCheckService {
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private SceneCheckMapper sceneCheckMapper;
    @Autowired
    private CheckMessageService checkMessageService;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public void checkSubmitHandle(Long billId) {
        if (billId != null) {
            SceneCheckEntity sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REFORM_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem, (Object)sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SceneCheckEntity::getReviewStatus, (Object)Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
            this.update((Wrapper)updateWrapper);
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                wrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.REFORM_STATE.getDescription());
                this.sceneCheckDetailService.update((Wrapper)wrapper);
            });
            ArrayList list = new ArrayList();
            List<SceneCheckDetailEntity> sceneCheckDetaillist = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetaillist.forEach(item -> {
                SceneCheckRecordEntity sceneCheckRecord = new SceneCheckRecordEntity();
                sceneCheckRecord.setPid(item.getId());
                sceneCheckRecord.setCheckId(item.getPid());
                sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.CHECK_STATE.getCode()));
                sceneCheckRecord.setReviewPerson(item.getReviewPerson());
                sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                sceneCheckRecord.setReviewResult(item.getReviewResult());
                sceneCheckRecord.setImgIds(item.getProblemImgIds());
                sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                sceneCheckRecord.setCheckItem(item.getCheckItem());
                sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                list.add(sceneCheckRecord);
            });
            this.sceneCheckRecordService.saveBatch(list, list.size());
            sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
            SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)sceneCheckEntity), SceneCheckVO.class);
            String reformDutyId = vo.getReformDutyId();
            String notifRelevantId = vo.getNotifRelevantId();
            vo.setMsgNum(Integer.valueOf(vo.getSceneCheckDetails().size()));
            vo.setMsgBillCode(vo.getBillCode());
            vo.setMsgId(vo.getId());
            if (StringUtils.isNotBlank((CharSequence)reformDutyId)) {
                String[] reformDuty = reformDutyId.split(",");
                this.checkMessageService.sendMsg(vo, reformDuty, NoticeEnum.CHECK_COMMIT_PASS);
            }
            if (StringUtils.isNotBlank((CharSequence)notifRelevantId)) {
                String[] notifRelevant = notifRelevantId.split(",");
                this.checkMessageService.sendMsg(vo, notifRelevant, NoticeEnum.CHECK_COMMIT_PASS_REVIEW);
            }
        }
    }

    @Override
    public boolean checkRevokeBeforeHandle(Long billId) {
        boolean flag = true;
        SceneCheckEntity sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("checkId", new Parameter("eq", (Object)sceneCheckEntity.getId()));
        param.getParams().put("operationType", new Parameter("eq", (Object)Integer.parseInt(OperationState.REFORM_STATE.getCode())));
        List list = this.sceneCheckRecordService.queryList(param, false);
        if (list.size() > 0) {
            flag = false;
        }
        return flag;
    }

    @Override
    public void checkRevokeAfterHandle(Long billId) {
        if (billId != null) {
            SceneCheckEntity sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem, (Object)sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SceneCheckEntity::getReviewStatus, null);
            this.update((Wrapper)updateWrapper);
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
                wrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.DEFULT_STATE.getCode());
                this.sceneCheckDetailService.update((Wrapper)wrapper);
            });
            LambdaUpdateWrapper deleteWrapper = new LambdaUpdateWrapper();
            deleteWrapper.eq(SceneCheckRecordEntity::getCheckId, (Object)sceneCheckEntity.getId());
            deleteWrapper.set(SceneCheckRecordEntity::getOperationType, (Object)Integer.parseInt(OperationState.CHECK_STATE.getCode()));
            this.sceneCheckRecordService.remove((Wrapper)deleteWrapper);
        }
    }

    @Override
    public void updateSceneCheckOverdue() {
        this.sceneCheckMapper.updateSceneCheckOverdue();
    }

    @Override
    public void updateSceneCheckOverdueNumber() {
        this.sceneCheckMapper.updateSceneCheckOverdueNumber();
    }

    @Override
    public List<XcjcsssjhzVO> getXcjcsssjhz(List<Long> orgIds, String jcxSort, String dzgSort, String yqwzgSort) {
        return ((SceneCheckMapper)this.baseMapper).getXcjcsssjhz(orgIds, jcxSort, dzgSort, yqwzgSort);
    }
}

