/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scheme.service.impl;

import com.ejianc.business.scheme.bean.SchemeApprovalEntity;
import com.ejianc.business.scheme.mapper.SchemeApprovalMapper;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.business.scheme.vo.SchemeApprovalVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="schemeApprovalService")
public class SchemeApprovalServiceImpl
extends BaseServiceImpl<SchemeApprovalMapper, SchemeApprovalEntity>
implements ISchemeApprovalService {
    private static final String BILL_CODE_ROLE = "SCHEME_APPROVAL_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<SchemeApprovalVO> saveOrUpdate(SchemeApprovalVO saveorUpdateVO) {
        SchemeApprovalEntity entity = (SchemeApprovalEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SchemeApprovalEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SchemeApprovalVO.class));
    }
}

