/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scheme.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scheme.bean.SchemePlanChangeEntity;
import com.ejianc.business.scheme.bean.SchemePlanDetailChangeEntity;
import com.ejianc.business.scheme.bean.SchemePlanEntity;
import com.ejianc.business.scheme.enums.ChangeStatusEnum;
import com.ejianc.business.scheme.service.ISchemePlanChangeService;
import com.ejianc.business.scheme.service.ISchemePlanService;
import com.ejianc.business.scheme.vo.SchemePlanChangeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"schemePlanChange"})
public class SchemePlanChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISchemePlanChangeService service;
    @Autowired
    private ISchemePlanService planService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SchemePlanChangeVO> saveOrUpdate(@RequestBody SchemePlanChangeVO saveOrUpdateVO) {
        SchemePlanChangeEntity entity = (SchemePlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SchemePlanChangeEntity.class));
        if (ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode() == entity.getChangeState()) {
            throw new BusinessException("\u8be5\u65bd\u5de5\u65b9\u6309\u8ba1\u5212\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        SchemePlanEntity masterPlan = (SchemePlanEntity)((Object)this.planService.getById(saveOrUpdateVO.getPlanId()));
        UserContext userContext = this.sessionManager.getUserContext();
        SchemePlanChangeEntity saveEntity = null;
        if (null == saveOrUpdateVO.getId()) {
            saveEntity = (SchemePlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SchemePlanChangeEntity.class));
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            saveEntity.setBillCode(masterPlan.getBillCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (SchemePlanChangeEntity)((Object)this.service.getById(saveOrUpdateVO.getId()));
            saveEntity.setProjectId(saveOrUpdateVO.getProjectId());
            saveEntity.setProjectName(saveOrUpdateVO.getProjectName());
            saveEntity.setRemark(saveOrUpdateVO.getRemark());
            saveEntity.setBillCode(saveOrUpdateVO.getBillCode());
            saveEntity.setModifyUserName(userContext.getUserName());
        }
        saveEntity.setPlanDetail(BeanMapper.mapList((Iterable)saveOrUpdateVO.getPlanDetail(), SchemePlanDetailChangeEntity.class));
        SchemePlanChangeEntity schemePlanChangeEntity = this.service.saveOrUpdatePlan(saveEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)schemePlanChangeEntity), SchemePlanChangeVO.class));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SchemePlanChangeVO> queryDetail(Long id) {
        SchemePlanChangeEntity entity = (SchemePlanChangeEntity)((Object)this.service.selectById(id));
        SchemePlanChangeVO vo = (SchemePlanChangeVO)BeanMapper.map((Object)((Object)entity), SchemePlanChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemePlanChangeVO> vos) {
        this.service.deleteChangePlan(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SchemePlanChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SchemePlanChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

